//J M Smith, H C Van Ness and M M Abbott;Introduction to Chemical Engineering Thermodynamics; 7th Edition. 

//Chapter-4:Heat Effects
//Example: 4.3 Page 132
//Title: Calculate the final temperature of ammonia
//==================================================================================
model Ex4_3

//==================================
//Parameter section
parameter Real T0(unit = "K") =533.15 "Initial temperature of ammonia";
parameter Real n(unit = "kmol") =11.3 "No. of moles of ammonia";
parameter Real R(unit = "kJ/(kmol K)") =8.314 "Universal gas constant";
parameter Real Q(unit = "MJ") =422 "Amount of heat added";

//==================================
//Variable section
Real T(unit = "K",start = 533.15) "Final temperature of ammonia";
Real deltaH(unit = "kJ/kmol") "Enthalpy change for 1 kmol";

//==================================
//Equation section
equation
deltaH = Q*1000/n;//to convert MJ to kJ
deltaH = R*(3.578*T0*(T/T0-1)+(3.02*0.001/2)*T0^2*((T/T0)^2-1));//integrate equation for deltaH with constants substituted

end Ex4_3;
//==================================================================================
