//J M Smith, H C Van Ness and M M Abbott;Introduction to Chemical Engineering Thermodynamics; 7th Edition. 

//Chapter-4:Heat Effects
//Example: 4.6 Page 141
//Title: Calculate standard heat of methanol synthesis
//==================================================================================
model Ex4_6

//==================================
//Parameter section
parameter Real T(unit = "K") =1073.15 "Temperature of reaction";
parameter Real[3] nu(unit = "") ={1,-1,-2} "Stoichiometric coefficients of CH3OH,CO and H2";
parameter Real[3] A(unit = "") ={2.211,3.376,3.249} "Cp constants of CH3OH,CO and H2";
parameter Real[3] B(unit = "") ={12.216,0.557,0.422} "Cp constants of CH3OH,CO and H2";
parameter Real[3] C(unit = "") ={-3.45,0,0} "Cp constants of CH3OH,CO and H2";
parameter Real[3] D(unit = "") ={0,-0.031,0.083} "Cp constants of CH3OH,CO and H2";
parameter Real[3] deltaHf(unit = "J") ={-200660,-110525,0} "Heat of formations of CH3OH,CO and H2";
parameter Real R(unit = "J/(mol K)") =8.314 "Universal gas constant";

//==================================
//Variable section
Real deltaH0(unit= "J") "Heat of reaction at 298.15 K";
Real deltaA(unit= "") "Cp constant";
Real deltaB(unit= "") "Cp constant";
Real deltaC(unit= "") "Cp constant";
Real deltaD(unit= "") "Cp constant";
Real deltaH(unit= "J") "Heat of reaction at T";
Real tau(unit = "") "Ratio of standard and reaction temperatures";

//==================================
//Equation section
equation
tau = T/298.15;
deltaH0 = nu[1]*deltaHf[1]+nu[2]*deltaHf[2]+nu[3]*deltaHf[3];
deltaA = nu[1]*A[1]+nu[2]*A[2]+nu[3]*A[3];
deltaB = (nu[1]*B[1]+nu[2]*B[2]+nu[3]*B[3])*(1/10)^3;
deltaC = (nu[1]*C[1]+nu[2]*C[2]+nu[3]*C[3])*(1/10)^6;
deltaD = (nu[1]*D[1]+nu[2]*D[2]+nu[3]*D[3])*(10)^5;
deltaH = deltaH0+R*(deltaA*298.15*(tau-1)+deltaB/2*298.15^2*(tau^2-1)+deltaC/3*298.15^3*(tau^3-1)+deltaD/298.15*(tau-1)/tau);
//The answer may vary due to rounding off values

end Ex4_6;
//==================================================================================