//J M Smith, H C Van Ness and M M Abbott;Introduction to Chemical Engineering Thermodynamics; 7th Edition. 

//Chapter-4:Heat Effects
//Example: 4.8 Page 144
//Title: Calculate heat requirement for the reactor
//==================================================================================
model Ex4_8

//==================================
//Parameter section
parameter Real T(unit = "K") =1300 "Temperature of reaction";
parameter Real T_f(unit = "K") =600 "Temperature of feed";
parameter Real T0(unit = "K") =298.15 "Reference temperature";
parameter Real xp(unit = "") =0.174 "Mole fraction of CO in product stream";
parameter Real T(unit = "K") =1300 "Temperature of reaction";
parameter Real deltaH_1(unit = "J") =205813 "Change in enthalpy of first reaction";
parameter Real deltaH_2(unit = "J") =-41166 "Change in enthalpy of second reaction";
parameter Real deltaH_3(unit = "J") =164647 "Change in enthalpy of third added reaction";
parameter Real[5] A(unit = "") ={1.702,3.376,3.249,5.457,3.470} "Cp constants for CH4, CO, H2, CO2, H2O respectively";
parameter Real[5] B(unit = "") ={9.081E-3,0.557E-3,0.422E-3,1.045E-3,1.450E-3} "Cp constants for CH4, CO, H2, CO2, H2O respectively";
parameter Real[5] C(unit = "") ={-2.164E-6,0,0,0,0} "Cp constants for CH4, CO, H2, CO2, H2O respectively";
parameter Real[5] D(unit = "") ={0,-0.031E5,0.083E5,-1.157E5,0.121E5} "Cp constants for CH4, CO, H2, CO2, H2O respectively";
parameter Real R(unit = "J/(mol K)") =8.314 "Universal gas constant";

//==================================
//Variable section
Real tau(unit = "") "Ratio of reaction and reference temperature";
Real tau_f(unit = "") "Ratio of feed and reference temperature";
Real[4] n(unit = "mol") "Moles of CO, H2, CO2, H2O respectively";
Real deltaH_0(unit = "J") "Change in enthalpy of reaction at reference temperature";
Real[6] Cp0byR(unit = "") "Cp constants for CH4, CO, H2, CO2, H2O at 1300 K and 298.15 K respectively";
Real deltaH_P(unit = "J") "Change in enthalpy of products";
Real deltaH_R(unit = "J") "Change in enthalpy at reference temperature";
Real deltaH(unit = "J") "Change in enthalpy of reaction";
Real Q(unit = "J") "Heat energy";

//==================================
//Equation section
equation
n[1] = xp*5;
n[2] = 4-xp*5;
n[3] = 1-xp*5;
n[4] = xp*5;
deltaH_0 = n[1]*deltaH_1+n[3]*deltaH_3;
tau = T/T0;
tau_f = T_f/T0;
Cp0byR[1] = (A[1]+B[1]/2*T0*(tau_f+1)+C[1]/3*T0^2*(tau_f^2+tau_f+1)+D[1]/((tau_f)*T0^2));
Cp0byR[6] = (A[5]+B[5]/2*T0*(tau_f+1)+C[5]/3*T0^2*(tau_f^2+tau_f+1)+D[5]/((tau_f)*T0^2));
deltaH_R = R*(Cp0byR[1]+2*Cp0byR[6])*(T0-T_f);
for i in 2:5 loop
Cp0byR[i] = (A[i]+B[i]/2*T0*(tau+1)+C[i]/3*T0^2*(tau^2+tau+1)+D[i]/((tau)*T0^2));
end for;
deltaH_P = R*(n[1]*Cp0byR[2]+n[2]*Cp0byR[3]+n[3]*Cp0byR[4]+n[4]*Cp0byR[5])*(T-T0);
deltaH = deltaH_R+deltaH_0+deltaH_P;
Q = deltaH;

end Ex4_8;
//==================================================================================