//J M Smith, H C Van Ness and M M Abbott;Introduction to Chemical Engineering Thermodynamics; 7th Edition. 

//Chapter-5:The second law of thermodynamics
//Example: 5.3 Page 172
//Title: Calculate final temperature of methane gas
//==================================================================================
model Ex5_3

//==================================
//Parameter section
parameter Real T1(unit="K")=550 "Initial temperature";
parameter Real P1(unit="bar")=5 "Initial pressure";
parameter Real P2(unit="bar")=1 "Final pressure";
parameter Real A(unit="")=1.702 "Cp constants";
parameter Real B(unit="")=9.081E-3 "Cp constants";
parameter Real C(unit="")=-2.167E-6 "Cp constants";
parameter Real R(unit = "J/(mol K)") =8.314 "Universal gas constant";

//==================================
//Variable section
Real Cp(unit="W/(K mol)") "Specific heat capacity";
Real T2(start=100, unit = "K") "Final temperature";

//==================================
//Equation section
equation
T2 = T1*exp(log(P2/P1)/(Cp/R));
Cp = R*(A+(B*T1+C*T1^2*((T2/T1)+1)/2)*((T2/T1)-1)/log(T2/T1)); //Constants from Table C.1

end Ex5_3;
//==================================================================================
