//J M Smith, H C Van Ness and M M Abbott;Introduction to Chemical Engineering Thermodynamics; 7th Edition. 

//Chapter-5:The second law of thermodynamics
//Example: 5.4 Page 175
//Title: Calculate change in entropy
//==================================================================================
model Ex5_4

//==================================
//Parameter section
parameter Real m1(unit="kg")=40 "Mass of steel casting";
parameter Real cp1(unit="kJ/(kg K)")=0.5 "Specific heat capacity of casting";
parameter Real T1(unit="K")=723.15 "Temperature of casting";
parameter Real m2(unit="kg")=150 "Mass of oil";
parameter Real cp2(unit="kJ/(kg K)")=2.5 "Specific heat capacity of oil";
parameter Real T2(unit="K")=298.15 "Temperature of oil";

//==================================
//Variable section
Real deltaSa(unit="kJ/K") "Change in entropy for the casting";
Real T(unit="K") "Final temperature of oil and steel";
Real deltaSb(unit="kJ/K") "Change in entropy for the oil";
Real deltaSt(unit="kJ/K") "Total change in entropy";

//==================================
//Equation section
equation
m1*cp1*(T-T1) = -m2*cp2*(T-T2);
deltaSa = m1*cp1*log(T/T1);
deltaSb = m2*cp2*log(T/T2);
deltaSt = deltaSa+deltaSb;

end Ex5_4;
//==================================================================================