//J M Smith, H C Van Ness and M M Abbott;Introduction to Chemical Engineering Thermodynamics; 7th Edition. 

//Chapter-6:Thermodynamic properties of fluids
//Example: 6.7 Page 227
//Title: Determine the downstream state of stream
//==================================================================================
model Ex6_7

//==================================
//Parameter section
parameter Real t1(unit="K")=523.15 "Initial temperature of steam";
parameter Real P1(unit="kPa")=1000 "Initial pressure of steam";
parameter Real P2(unit="kPa")=200 "Final pressure of steam";
parameter Real H1(unit="kJ/kg")=2942.9 "Initial enthalpy of steam";
parameter Real S1(unit="kJ/kg K")=6.9252 "Initial entropy of steam";
parameter Real S2l(unit="kJ/kg K")=1.5301 "Final liquid entropy";
parameter Real S2v(unit="kJ/kg K")=7.1268 "Final vapor entropy";
parameter Real H2l(unit="kJ/kg")=504.7 "Final liquid enthalpy";
parameter Real H2v(unit="kJ/kg")=2706.3 "Final vapor enthalpy";

//==================================
//Variable section
Real x2v(unit="") "Dryness fraction";
Real H2(unit="kJ/kg") "Final enthalpy of steam";
Real S2(unit="kJ/kg K") "Final entropy of steam";
Real deltaH(unit="kJ/kg") "Change in enthalpy of steam";

//==================================
//Equation section
equation
S2 = S1;
S2 = (1-x2v)*S2l+x2v*S2v;
H2 = H2l*(1-x2v)+H2v*x2v;
deltaH = H2-H1;

end Ex6_7;
//==================================================================================