//J M Smith, H C Van Ness and M M Abbott;Introduction to Chemical Engineering Thermodynamics; 7th Edition. 

//Chapter-6:Thermodynamic properties of fluids
//Example: 6.8 Page 229
//Title: Estimate energy to be transferred to tank
//==================================================================================
model Ex6_8

//==================================
//Parameter section
parameter Real Hd(unit="kJ/kg")=293 "Enthalpy of saturated liquid at 343.15 K";
parameter Real Hltank(unit="kJ/kg")=419.1 "Enthalpy of saturated liquid at 373.15 K";
parameter Real Hvtank(unit="kJ/kg")=504.7 "Enthalpy of saturated vapor at 373.15 K";
parameter Real V(unit="m^3")=1.5 "Volume of tank";
parameter Real m1(unit="kg")=500 "Mass of liquid water";
parameter Real T(unit="K")=273.15 "Temperature of water";
parameter Real P(unit="kPa")=101.33 "Pressure of water";
parameter Real M(unit="kg")=750 "Mass of liquid water added";

//==================================
//Variable section
Real m1v(unit="kg") "Mass of vapor";
Real m1H1(unit="kJ") "Total initial enthalpy inside tank";
Real m2l(unit="kg") "Final mass of liquid";
Real m2v(unit="kg") "Final mass of vapor";
Real m2H2(unit="kJ") "Total final enthalpy inside tank";
Real Q(unit="kJ") "Energy transferred to tank";

//==================================
//Equation section
equation
m1H1 = m2v+m2l;
m1v = (V-m1*0.001044)/1.673; //0.001044 is the specific volume of  liquid water
m1H1 = m1+m1v+M;
V = 1.673*m2v+0.001044*m2l;
m2H2 = m2l*Hltank+m2v*Hvtank;
Q = m2H2-m1H1;
//The answer provided in the textbook is wrong(for m1v)
end Ex6_8;
//==================================================================================