//J M Smith, H C Van Ness and M M Abbott;Introduction to Chemical Engineering Thermodynamics; 7th Edition. 

//Chapter-7:Applications of Thermodynamics to Flow Processes
//Example: 7.10 Page 278
//Title: Calculate work of pump and entropy changes
//==================================================================================
model Ex7_10

//==================================
//Parameter section
parameter Real P1(unit="kPa")=10 "Initial pressure";
parameter Real P2(unit="kPa")=8600 "Discharge pressure";
parameter Real T1(unit="K")=318.15 "Initial temperature";
parameter Real n(unit="")=0.75 "Pump efficiency";
parameter Real V(unit="cm^3/kg")=1010 "Specific volume";
parameter Real beta(unit="1/K")=0.000425 "Incompresssible fluid property";
parameter Real cp(unit="kJ/(kg K)")=4.178 "Specific heat capacity";

//==================================
//Variable section
Real deltaH(unit="kJ/kg") "Change in enthalpy";
Real Wsiso(unit="kJ/kg") "Isentropic work done";
Real Ws(unit="kJ/kg") "Actual work done";
Real deltaT(unit="K") "Temperature difference";
Real deltaS(unit="kJ/kg K") "Entropy change";

//==================================
//Equation section
equation
Wsiso = V*(P2-P1)/10^6; //Ws_isentropic=deltaHs
deltaH = Wsiso/n;
Ws = deltaH;
deltaH = cp*deltaT+V*(1-beta*T1)*(P2-P1)/10^6;
deltaS = cp*log((T1+deltaT)/T1)-beta*V*(P2-P1)/10^6;

end Ex7_10;
//==================================================================================