//J M Smith, H C Van Ness and M M Abbott;Introduction to Chemical Engineering Thermodynamics; 7th Edition. 

//Chapter-7:Applications of Thermodynamics to Flow Processes
//Example: 7.2 Page 262
//Title: Calculate A/A1 ratios
//==================================================================================
model Ex7_2

//==================================
//Parameter section
parameter Real P1(unit="kPa")=700 "Initial pressure";
parameter Real T1(unit="K")=573.15 "Initial temperature";
parameter Real u1(unit="m/s")=30 "Initial velocity";
parameter Real S1(unit="kJ/(kg K)")=7.2997 "Initial entropy";
parameter Real H1(unit="J/kg")=3059800 "Initial enthalpy";
parameter Real V1(unit="cm^3/g")=371.39 "Initial specific volume";
parameter Real[5] P(unit="kPa")={600,500,400,300,200} "Final pressure";
parameter Real[5] V(unit="cm^3/g")={418.25,481.26,571.23,711.23,970.04} "Final specific volume";
parameter Real i(unit="")=1 "Control variable";
parameter Real[5] H(unit="J/kg")={3020400,2975700,2923490,2859900,2777348} "Final enthalpy";

//==================================
//Variable section
Real[5] u(unit="m/s") "Final velocity";
Real[5] AbyA1(unit="") "A/A1 ratio";

//==================================
//Equation section
equation
for i in 1:5 loop
u[i] = (u1^2-2*(H[i]-H1))^0.5;
AbyA1[i] = u1/V1*V[i]/u[i];
end for;

end Ex7_2;
//==================================================================================