//J M Smith, H C Van Ness and M M Abbott;Introduction to Chemical Engineering Thermodynamics; 7th Edition. 

//Chapter-7:Applications of Thermodynamics to Flow Processes
//Example: 7.7 Page 270
//Title: Calculate isoentropic work of ethylene
//==================================================================================
model Ex7_7

//==================================
//Parameter section
parameter Real P1(unit="bar")=45 "Initial pressure";
parameter Real T1(unit="K")=573.15 "Initial temperature";
parameter Real P2(unit="bar")=2 "Discharge pressure";
parameter Real Tc(unit="K")=282.3 "Critical temperature";
parameter Real Pc(unit="bar")=50.4 "Critical pressure";
parameter Real R(unit="J/ mol K")=8.314 "Univeral gas constant";
parameter Real omega(unit="")=0.087 "";
parameter Real A(unit="")=1.424 "cp constants";
parameter Real B(unit="")=0.014394 "cp constants";
parameter Real C(unit="")=-0.000004392 "cp constants";
parameter Real D(unit="")=0 "cp constants";

//==================================
//Variable section
Real T2_a(unit="K") "Discharge temperature";
Real[2] T2_b(unit="K") "Discharge temperature";
Real Tr1(unit="K") "Initial reduced temperature";
Real Pr1(unit="bar") "Initial reduced pressure";
Real H1R(unit="J/mol") "Initial reduced enthalpy";
Real H2R(unit="J/mol") "Final reduced enthalpy";
Real S1R(unit="J/(mol K)") "Initial reduced entropy";
Real[2] S2R(unit="J/(mol K)") "Final reduced entropy";
Real[2] Tr2(unit="K") "Final reduced temperature";
Real[2] Pr2(unit="bar") "Final reduced pressure";
Real[2] cph(unit="J/K mol") "Heat capacity";
Real cps(unit="J//K mol") "Heat capacity";
Real[2] tau(unit="") "Ratio of temperatures";
Real[3] B0(unit="") "Quantity B0";
Real[3] B1(unit="") "Quantity B1";
Real[3] diffB0(unit="") "dB0/dt";
Real[3] diffB1(unit="") "dB1/dt";
Real Ws_a(unit="J/mol") "Isentropic work";
Real Ws_b(unit="J/mol") "Isentropic work";

//==================================
//Equation section
equation
T2_a = exp(log(P2/P1)*R/cps+log(T1));
tau[1] = T2_a/T1;
cps = R*(A+(B*T1+(C*T1^2+D/(tau[1]^2*T1^2))*(tau[1]+1)/2)*(tau[1]-1)/log(tau[1]));
cph[1] = R*(A+B*T1/2*(tau[1]+1)+C/3*T1^2*(tau[1]^2+tau[1]+1)+D/(tau[1]*T1^2));
Ws_a = cph[1]*(T2_a-T1);
Tr1 = T1/Tc;
Pr1 = P1/Pc;
H1R = R*Tc*Pr1*(B0[1]-Tr1*diffB0[1]+omega*(B1[1]-Tr1*diffB1[1]));
B0[1] = 0.083-0.422/Tr1^1.6;
B1[1] = 0.139-0.172/Tr1^4.2;
diffB0[1] = 0.675/Tr1^2.6;
diffB1[1] = 0.722/Tr1^5.2;
S1R = -R*Pr1*(diffB0[1]+omega*diffB1[1]);
T2_b[1] = T2_a;

Tr2[1] = T2_b[1]/Tc;
Pr2[1] = P2/Pc;
B0[2] = 0.083-0.422/Tr2[1]^1.6;
B1[2] = 0.139-0.172/Tr2[1]^4.2;
diffB0[2] = 0.675/Tr2[1]^2.6;
diffB1[2] = 0.722/Tr2[1]^5.2;
S2R[1] = -R*Pr2[1]*(diffB0[2]+omega*diffB1[2]);
S1R = S2R[1]+cps*log(T2_b[2]/T1)-R*log(P2/P1);
Tr2[2] = T2_b[2]/Tc;
Pr2[2] = P2/Pc;
B0[3] = 0.083-0.422/Tr2[2]^1.6;
B1[3] = 0.139-0.172/Tr2[2]^4.2;
diffB0[3] = 0.675/Tr2[2]^2.6;
diffB1[3] = 0.722/Tr2[2]^5.2;
S2R[2] = -R*Pr2[2]*(diffB0[3]+omega*diffB1[3]);
H2R = R*Tc*Pr2[2]*(B0[3]-Tr2[2]*diffB0[3]+omega*(B1[3]-Tr2[2]*diffB1[3]));
tau[2] = T2_b[2]/T1;
cph[2] =R*(A+B*T1/2*(tau[2]+1)+C/3*T1^2*((tau[2])^2+tau[2]+1)+D/(tau[2]*T1^2));
Ws_b = cph[2]*(T2_b[2]-T1)+H2R-H1R;
//The answer may slightly vary due to rounding off values

end Ex7_7;
//==================================================================================