package Ex8_1
  //J M Smith, H C Van Ness and M M Abbott;Introduction to Chemical Engineering Thermodynamics; 7th Edition.
  //Chapter-8:Production of Power from Heat
  //Example: 8.1 Page 294
  //Title: Calculate efficiency of steam turbine
  //==================================================================================

  model Ex8_1_a
//==================================
//Parameter section
parameter Real P1(unit="kPa")=8600 "Initial pressure";
parameter Real T1(unit="K")=773.15 "Initial temperature";
parameter Real P2(unit="kPa")=10 "Discharge pressure";
parameter Real S1tur(unit="kJ/(kg K)")=6.6858 "Initial entropy";
parameter Real H1tur(unit="kJ/kg")=3391.6 "Initial enthalpy";
parameter Real S2l(unit="kJ/(kg K)")=0.6493 "Discharge liquid entropy";
parameter Real H2l(unit="kJ/kg")=191.8 "Discharge liquid enthalpy";
parameter Real S2v(unit="kJ/(kg K)")=8.1511 "Discharge vapor entropy";
parameter Real H2v(unit="kJ/kg")=2584.8 "Discharge vapor enthalpy";
parameter Real H2(unit="kJ/kg")=3391.6 "Enthalpy of saturated liquid at 8600kPa & 773.15 K";
parameter Real H4(unit="kJ/kg")=191.8 "Enthalpy of saturated liquid at 10kPa";
parameter Real V(unit="cm^3/kg")=1010 "Specific volume";

//==================================
//Variable section
Real H3_a(unit="kJ/kg") "Wet discharge enthalpy with efficiency as 1";
Real H1_a(unit="kJ/kg") "Actual discharge enthalpy";
Real deltaHs(unit="kJ/kg") "Change in enthalpy with efficiency as 1";
Real x2d(unit="") "Mole fraction if efficiency was 1";
Real W_isent_turbine_a(unit="kJ/kg") "Isentropic work by turbine";    
Real W_isent_pump_a(unit="kJ/kg") "Isentropic work by pump";
Real Qcondenser_a(unit="kJ/kg") "Heat transferred in condensor";
Real Qboiler_a(unit="kJ/kg") "Heat transferred in boiler";
Real n_a(unit="") "Thermal efficiency of Rankine cycle";
Real W_rankine(unit="kJ/kg") "Network of the rankine cycle";
  
//==================================
//Equation section
equation
S1tur = S2l+x2d*(S2v-S2l);
H3_a = H2l+x2d*(H2v-H2l);
deltaHs = H3_a-H1tur;
W_isent_turbine_a = deltaHs;
Qcondenser_a = H4-H3_a;
W_isent_pump_a = V*(P1-P2)/10^6;
H1_a = H4+W_isent_pump_a;
Qboiler_a = H2-H1_a;
W_rankine = W_isent_pump_a+W_isent_turbine_a;
n_a = abs(W_rankine)/Qboiler_a;
end Ex8_1_a;
//==================================

model Ex8_1_b
//==================================
//Reference section
extends Ex8_1_a;

//==================================
//Parameter section
parameter Real n(unit="")=0.75 "Turbine and pump efficiency of practical cycle";

//==================================
//Variable section
Real Qcondenser_b(unit="kJ/kg") "Heat transferred in condensor";
Real W_turbine_b(unit="kJ/kg") "Work by turbine";    
Real W_pump_b(unit="kJ/kg") "Work by pump";
Real W_net_b(unit="kJ/kg") "Net work done";
Real H1_b(unit="kJ/kg") "Initial turbine enthalpy";
Real H3_b(unit="kJ/kg") "Final turbine enthalpy";
Real Qboiler_b(unit="kJ/kg") "Heat transferred in boiler";
Real n_b(unit="") "Thermal efficiency of practical cycle";

//==================================
//Equation section
equation
W_turbine_b = n*W_isent_turbine_a;
H3_b = H2+W_turbine_b;
Qcondenser_b = H4-H3_b;
W_pump_b = W_isent_pump_a/n;
W_net_b = W_turbine_b+W_pump_b;
H1_b = H4+W_pump_b;
Qboiler_b = H2-H1_b;
n_b = abs(W_net_b)/Qboiler_b;

end Ex8_1_b;
//==================================

model Ex8_1_c
//==================================
//Reference section
extends Ex8_1_b;

//==================================
//Parameter section
parameter Real W_net_c(unit="kW")=-80000 "Net work done";

//==================================
//Variable section
Real Qcondenser_c(unit="kJ/s") "Net heat transferred in condensor";
Real Qboiler_c(unit="kJ/s") "Net heat transferred in boiler";
Real m(unit="kg/s") "Net mass flow rate";

//==================================
//Equation section
equation
m = W_net_c/W_net_b;
Qcondenser_c = m*Qcondenser_b;
Qboiler_c = m*Qboiler_b;
end Ex8_1_c;

//==================================

end Ex8_1;
