package Ex8_4
//J M Smith, H C Van Ness and M M Abbott;Introduction to Chemical Engineering Thermodynamics; 7th Edition.
//Chapter-8:Production of Power from Heat
//Example: 8.4 Page 308
//Title: Calculate efficiency of ideal air cycle & under adiabatic conditions
//==================================================================================
model Ex8_4_a
  
//==================================
//Parameter section
parameter Real PBbyPA(unit="")=6 "Ratio of final and final and initial pressures";
parameter Real TC(unit="K")=1033.15 "Maximum permissible temperature in turbine";
parameter Real TA(unit="K")=298.15 "Temperature of air entering";
parameter Real gamma(unit="")=1.4 "Ratio of heat capacities";

//==================================
//Variable section
Real n_a(unit="") "Efficiency of ideal air cycle";

//==================================
//Equation section
equation
n_a = 1-(1/PBbyPA)^((gamma-1)/gamma);

end Ex8_4_a;
//==================================

model Ex8_4_b
//==================================
//Reference section
extends Ex8_4_a;

//==================================
//Parameter section
parameter Real nt(unit="")=0.86 "Turbine efficiency of practical cycle";  
parameter Real nc(unit="")=0.83 "Compressor efficiency of practical cycle";

//==================================
//Variable section
Real n_b(unit="") "Efficiency of adiabatic air cycle";
Real TCbyTA(unit="") "Ratio TC & TA";
Real alpha(unit="") "Equation constant";

//==================================
//Equation section
equation
TCbyTA = TC/TA;
alpha = PBbyPA^((gamma-1)/gamma);
n_b = (nt*nc*TCbyTA*(1-1/alpha)-(alpha-1))/(nc*(TCbyTA-1)-(alpha-1));

end Ex8_4_b;
//==================================

end Ex8_4;
  
