//J M Smith, H C Van Ness and M M Abbott;Introduction to Chemical Engineering Thermodynamics; 7th Edition. 

//Chapter-9:Refrigeration and Liquefaction
//Example: 9.3 Page 330
//Title: Calculate the temperature of steam entering throttle 
//==================================================================================
model Ex9_3

//==================================
//Parameter section
parameter Real H4(unit="kJ/kg")=1140 "Enthalpy at 300 K and 60 bar";
parameter Real H15(unit="kJ/kg")=1188.9 "Enthalpy at 295 K and 1 bar";
parameter Real H9(unit="kJ/kg")=285.4 "Enthalpy of saturated liquid at 111.5 K";
parameter Real H12(unit="kJ/kg")=796.9 "Enthalpy of saturated vapor at 111.5 K";
parameter Real H5(unit="kJ/kg")=1009.8 "Enthalpy at 253.6 K and 60 bar";
parameter Real x(unit="")=0.25 "Fraction of methane entering the exchanger";

//==================================
//Variable section
Real H14(unit="kJ/kg") "Enthalpy at the hot end of second exchanger";
Real T14(unit="K") "Temperature at the hot end of the second exchanger";
Real z(unit="") "Fraction of methane entering that is liquified";
Real H7(unit="kJ/kg") "Enthalpy at the end of second exchanger";
Real T7(unit="K") "Temperature at the cold end of the second exchanger";
Real T7d(unit="K") "Temperature at the cold end of the second exchanger when x=0";
Real zd(unit="") "Fraction of methane entering that is liquified when x=0";
Real H7d(unit="kJ/kg") "Enthalpy at the end of second exchanger when x=0";

//==================================
//Equation section
equation
z = (x*(H12-H5)+H4-H15)/(H9-H15);
H14 = (H5-H4)/(1-z)+H15;
T14 = 227.2;//from tables corresponding to H14
H7 = H5-(1-z)/(1-x)*(H14-H12);
T7 = 197.6; //from tables corresponding to H7
zd = (H4-H15)/(H9-H15);
H7d = H4-(1-zd)*(H15-H12);//H10=H12
T7d = 206.6; //from tables corresponding to H7d

end Ex9_3;
//==================================================================================