//J M Smith, H C Van Ness and M M Abbott;Introduction to Chemical Engineering Thermodynamics; 7th Edition. 

//Chapter-1:Introduction
//Example: 1.2 Page 7
//Title: Pressure 
//==================================================================================
model Ex1_2

//==================================
// Library section
extends Modelica.Constants ;

//==================================
//Parameter section
parameter Real m(unit = "kg") = 6.14 "Mass of piston and pan";
parameter Real g(unit = "m s2") = 9.82 "Local acceleration of gravity";
parameter Real BP(unit = "torr") = 748  "Barometric pressure";
parameter Real d(unit = "cm") = 1 "Diameter of piston";

//==================================
//Variable section
Real F(unit = "N") "Force on piston";
Real GP(unit = "N/cm2") "Gauge pressure";
Real P(unit = "N/cm2") "Absolute pressure";

//==================================
//Equation section
equation
F=m*g;//Newton's second law of motion
GP=F/(pi/4*d^2);
P=GP+BP*0.013332; //To convert torr to N/cm^2

end Ex1_2;
//==================================================================================