//J M Smith, H C Van Ness and M M Abbott;Introduction to Chemical Engineering Thermodynamics; 7th Edition. 

//Chapter-1:Introduction
//Example: 1.4 Page 13
//Title: Energy 
//==================================================================================
model Ex1_4

//==================================
//Parameter section
parameter Real m(unit = "kg") = 2500 "Mass of elevator";
parameter Real z1(unit = "m") = 10 "Initial level of elevator from base";
parameter Real z2(unit = "m") = 100 "Highest level of elevator from base";
parameter Real g(unit ="m/s2") =9.80 "Acceleration of gravity";

//==================================
//Variable section
Real EP1(unit = "J") "Potential energy of elevator in its initial position";
Real W(unit = "J") "Work done in raising elevator";
Real EP2(unit = "J") "Potential energy of elevator in its highest position";
Real u3(unit = "m/s") "Velocity of elevator at base";
Real EP3(unit = "J") "Potential energy of elevator at base";
Real EK3(unit = "J") "Kinetic energy of elevator at base";
Real TE(unit = "J") "Total energy of elevator";

//==================================
//Equation section
equation
EP1 = m*z1*g;
W = m*g*(z2-z1);
EP2 = m*z2*g;
EK3 = EP2; //Principle of conservation of mechanical energy
u3 = (2*EK3/m)^0.5;
EP3 = EK3; //Final potential energy is equal to kinetic energy just before it stikes the base
TE = EP1+W;

end Ex1_4;
//==================================================================================