//J M Smith, H C Van Ness and M M Abbott;Introduction to Chemical Engineering Thermodynamics; 7th Edition. 

//Chapter-10:Vapor/Liquid Equilibrium- Introduction
//Example: 10.2 Page 358
//Title: Calculate compositions of vapor and liquid phases of carbonated water
//==================================================================================
model Ex10_2

//==================================
//Parameter section
parameter Real P2s(unit="bar")=0.01227 "Saturation pressure at 283.15 K from steam tables";
parameter Real H1(unit="bar")=990 "Henry's constant";
parameter Real x1(unit="")=0.01 "Mole fraction of CO2 in liquid";

//==================================
//Variable section
Real P(unit="bar") "Pressure of system";
Real y1(unit="") "Mole fraction of CO2 in vapor";
Real x2(unit="") "Mole fraction of water in liquid";
Real y2(unit="") "Mole fraction of water in vapor";

//==================================
//Equation section
equation
x2 = (1-x1);
P = x1*H1+x2*P2s;
y2 = x2*P2s/P;
y1 = (1-y2);

end Ex10_2;
//==================================================================================