package Ex10_3

//J M Smith, H C Van Ness and M M Abbott;Introduction to Chemical Engineering Thermodynamics; 7th Edition.
  //Chapter-10:Vapor/Liquid Equilibrium- Introduction
  //Example: 10.3 Page 359
  //Title: Calculate  temperature, pressure and composition
  //==================================================================================

model Ex10_3_a

//==================================
//Parameter section
parameter Real T(unit="K")=318.15 "Temperature of system";
parameter Real x1(unit="")=0.25 "Liquid composition of component 1";

//==================================
//Variable section
Real P1s(unit="kPa") "Saturated pressure of component 1";
Real P2s(unit="kPa") "Saturated pressure of component 2";
Real P(unit="kPa") "Pressure of system";
Real gamma1(unit="") "Activity coefficient of component 1";
Real gamma2(unit="") "Activity coefficient of component 2";
Real y1(unit="") "Vapor composition of component 1";
Real y2(unit="") "Vapor composition of component 2";

//==================================
//Equation section
equation
log(P1s) = 16.59158-3643.31/(T-33.424);
log(P2s) = 14.25326-2665.54/(T-53.424);
log(gamma1) = (2.771-0.00523*T)*(1-x1)^2;
log(gamma2) = (2.771-0.00523*T)*(x1)^2;
P = x1*gamma1*P1s+(1-x1)*gamma2*P2s;
y1 = x1*gamma1*P1s/P;
y2 = (1-x1)*gamma1*P1s/P;

end Ex10_3_a;
//==================================

model Ex10_3_b

//==================================
//Parameter section
parameter Real T(unit="K")=318.15 "Temperature of system";
parameter Real y1(unit="")=0.60 "Vapor composition of component 1";

//==================================
//Variable section
Real P1s(unit="kPa") "Saturated pressure of component 1";
Real P2s(unit="kPa") "Saturated pressure of component 2";
Real P(unit="kPa") "Pressure of system";
Real gamma1(unit="") "Activity coefficient of component 1";
Real gamma2(unit="") "Activity coefficient of component 2";
Real x1(unit="") "Liquid composition of component 1";
Real x2(unit="") "Liquid composition of component 2";

//==================================
//Equation section
equation
log(P1s) = 16.59158-3643.31/(T-33.424);
log(P2s) = 14.25326-2665.54/(T-53.424);
y1 = x1*gamma1*P1s/P;
P = x1*gamma1*P1s+(1-x1)*gamma2*P2s;
log(gamma1) = (2.771-0.00523*T)*(1-x1)^2;
log(gamma2) = (2.771-0.00523*T)*(x1)^2;
x2 = 1-x1;


end Ex10_3_b;
//==================================

model Ex10_3_c

//==================================
//Parameter section
parameter Real P(unit="kPa")=101.33 "Pressure of system";
parameter Real x1(unit="")=0.85 "Liquid composition of component 1";

//==================================
//Variable section
Real P1s(unit="kPa") "Saturated pressure of component 1";
Real P2s(unit="kPa") "Saturated pressure of component 2";
Real T(start=100,unit="K") "Temperature of system";
Real gamma1(unit="") "Activity coefficient of component 1";
Real gamma2(unit="") "Activity coefficient of component 2";
Real y1(unit="") "Vapor composition of component 1";
Real y2(unit="") "Vapor composition of component 2";

//==================================
//Equation section
equation
log(P1s) = 16.59158-3643.31/(T-33.424);
log(P2s) = 14.25326-2665.54/(T-53.424);
log(gamma1) = (2.771-0.00523*T)*(1-x1)^2;
log(gamma2) = (2.771-0.00523*T)*(x1)^2;
P = x1*gamma1*P1s+(1-x1)*gamma2*P2s;
y1 = x1*gamma1*P1s/P;
y2 = (1-x1)*gamma2*P2s/P;

end Ex10_3_c;

//==================================

model Ex10_3_d

//==================================
//Parameter section
parameter Real P(unit="kPa")=101.33 "Pressure of system";
parameter Real y1(unit="")=0.40 "Vapor composition of component 1";

//==================================
//Variable section
Real P1s(unit="kPa") "Saturated pressure of component 1";
Real P2s(unit="kPa") "Saturated pressure of component 2";
Real T(start=100,unit="K") "Temperature of system";
Real gamma1(unit="") "Activity coefficient of component 1";
Real gamma2(unit="") "Activity coefficient of component 2";
Real x1(unit="") "Liquid composition of component 1";
Real x2(unit="") "Liquid composition of component 2";

//==================================
//Equation section
equation
log(P1s) = 16.59158-3643.31/(T-33.424);
log(P2s) = 14.25326-2665.54/(T-53.424);
y1 = x1*gamma1*P1s/P;
(1-y1) = (1-x1)*gamma2*P2s/P;
log(gamma1) = (2.771-0.00523*T)*(1-x1)^2;
log(gamma2) = (2.771-0.00523*T)*(x1)^2;
x2 = 1-x1;

end Ex10_3_d;

//==================================

model Ex10_3_e

//==================================
//Parameter section
parameter Real T(unit="K")=318.15 "Temperature of system";

//==================================
//Variable section
Real P1s(unit="kPa") "Saturated pressure of component 1";
Real P2s(unit="kPa") "Saturated pressure of component 2";
Real P(unit="kPa") "Pressure of system";
Real gamma1(unit="") "Activity coefficient of component 1";
Real gamma2(unit="") "Activity coefficient of component 2";
Real y1(unit="") "Vapor composition of component 1";
Real y2(unit="") "Vapor composition of component 2";
Real x1(unit="") "Liquid composition of component 1";
Real x2(unit="") "Liquid composition of component 2";

//==================================
//Equation section
equation
y1+y2 = 1;
x1+x2 = 1;
((y1/x1)/(y2/x2)) = 1;
log(P1s) = 16.59158-3643.31/(T-33.424);
log(P2s) = 14.25326-2665.54/(T-53.424);
log(gamma1) = (2.771-0.00523*T)*(1-x1)^2;
log(gamma2) = (2.771-0.00523*T)*(x1)^2;
P = x1*gamma1*P1s+(1-x1)*gamma2*P2s;
y1 = x1*gamma1*P1s/P;

end Ex10_3_e;
//==================================
end Ex10_3;
