//J M Smith, H C Van Ness and M M Abbott;Introduction to Chemical Engineering Thermodynamics; 7th Edition. 

//Chapter-11:Solution Thermodynamics: Theory
//Example: 11.3 Page 388
//Title: Calculate volumes of pure methanol and water
//==================================================================================
model Ex11_3

//==================================
//Parameter section
parameter Real x1(unit="")=0.3 "Mole fraction of methanol in solution";
parameter Real Vbar1(unit="cm^3")=38.632 "Partial volume of methanol in solution";
parameter Real Vbar2(unit="cm^3/mol")=17.765 "Partial volume of water in solution";
parameter Real V1(unit="cm^3/mol")=40.727 "Pure species molar volume of methanol ";
parameter Real V2(unit="cm^3/mol")=18.068 "Pure species molar volume of water";
parameter Real Vt(unit="cm^3")=2000 "Total volume of solution";

//==================================
//Variable section
Real V(unit="cm^3/mol") "Molar volume of binary solution";
Real n(unit="mol") "Total number of moles";
Real n1(unit="mol") "Number of moles of methanol";
Real n2(unit="mol") "Number of moles of water";
Real Vt1(unit="cm^3") "Volume of pure methanol";
Real Vt2(unit="cm^3") "Volume of pure water";

//==================================
//Equation section
equation
V = x1*Vbar1+(1-x1)*Vbar2;
n = Vt/V;
n1 = x1*n;
n2 = (1-x1)*n;
Vt1 = n1*V1;
Vt2 = n2*V2;

end Ex11_3;
//==================================================================================