//J M Smith, H C Van Ness and M M Abbott;Introduction to Chemical Engineering Thermodynamics; 7th Edition. 

//Chapter-11:Solution Thermodynamics: Theory
//Example: 11.8 Page 408
//Title: Estimate fugacity of of 1-butene
//==================================================================================
model Ex11_8

//==================================
//Parameter section
parameter Real P(unit="bar")=70 "Pressure of system";
parameter Real T(unit="K")=473.15 "Temperature of system";
parameter Real Pc(unit="bar")=40.3 "Critical pressure of system";
parameter Real Tc(unit="K")=420 "Critical temperature of system";
parameter Real omega(unit="")=0.191 "Ratio of specific heats";

//==================================
//Variable section
Real f(unit="bar") "Fugacity";
Real Pr(unit="") "Reduced pressure of system";
Real Tr(unit="") "Reduced temperature of system";
Real phi0(unit="") "Virial coefficients";
Real phi1(unit="") "Virial coefficients";
Real phi(unit="") "Virial coefficients";

//==================================
//Equation section
equation
Pr = P/Pc;
Tr = T/Tc;
phi0 = 0.627;
phi1 = 1.096;//Byinterpolation in Tables E.15 and E.16
phi = phi0*phi1^omega;
f = phi*P;

end Ex11_8;
//==================================================================================