//J M Smith, H C Van Ness and M M Abbott;Introduction to Chemical Engineering Thermodynamics; 7th Edition. 

//Chapter-11:Solution Thermodynamics: Theory
//Example: 11.9 Page 410
//Title: Estimate fugacity coefficients 
//==================================================================================
model Ex11_9

//==================================
//Parameter section
parameter Real P(unit="kPa")=25 "Pressure of system";
parameter Real T(unit="K")=323.15 "Temperature of system";
parameter Real[3] ij(unit="")={11,22,12} ;
parameter Real[3] Tcij(unit="K")={535.5,591.8,563} "Critical temperatures";
parameter Real[3] Pcij(unit="kPa")={41.5,41.1,41.3} "Critical pressures";
parameter Real[3] Zcij(unit="")={0.249,0.264,0.256} ;
parameter Real[3] omega(unit="")={0.323,0.262,0.293} ;
parameter Real R(unit="bar cm^3/K mol")=83.14 "Universal gas constant";
parameter Real y1(unit="")=0.5 "Mole fraction of component 1 in vapor";

//==================================
//Variable section
Real[3] B0(unit="cm^3/mol") "Virial coefficients";
Real[3] B1(unit="cm^3/mol") "Virial coefficients";
Real[3] Trij(unit="K") "Reduced temperatures";
Real B11(unit="cm^3/mol") "Virial coefficients";
Real B22(unit="cm^3/mol") "Virial coefficients";
Real B12(unit="cm^3/mol") "Virial coefficients";
Real sigma12(unit="cm^3/mol") "Virial coefficient";
Real phi1(unit="cm^3/mol") "Fugacity coefficient of component 1";
Real phi2(unit="cm^3/mol") "Fugacity coefficient of component 2";

//==================================
//Equation section
equation
for i in 1:3 loop
Trij[i] = T/Tcij[i];
B0[i] = 0.083-0.422/Trij[i]^1.6;
B1[i] = 0.139-0.172/Trij[i]^4.2;
end for;
B22*Pcij[2]/(R*Tcij[2]) = B0[2]+omega[2]*B1[2];
B11*Pcij[1]/(R*Tcij[1]) = B0[1]+omega[1]*B1[1];
B12*Pcij[3]/(R*Tcij[3]) = B0[3]+omega[3]*B1[3];
sigma12 = 2*B12-B11-B22;
log(phi1) = P/(8314*T)*(B11+(1-y1)^2*sigma12);
log(phi2) = P/(8314*T)*(B22+(y1)^2*sigma12);

end Ex11_9;
//==================================================================================