//J M Smith, H C Van Ness and M M Abbott;Introduction to Chemical Engineering Thermodynamics; 7th Edition. 

//Chapter-12:Solution Thermodynamics: Applications
//Example: 12.4 Page 457
//Title: Calculate heat of formation of LiCl
//==================================================================================
model Ex12_4
//Li + 1/2 Cl2 -->  LiCl   (1)
//LiCl + 12H2O  -->  LiCl(12H2O)  (2)

//==================================
//Parameter section
parameter Real deltaH1(unit="J")=-408610 "Enthalpy change of reaction (1)";
parameter Real deltaH2(unit="J")=-33614 "Enthalpy change of reaction (2)";

//==================================
//Variable section
Real deltaH(unit="J") "Heat of formation of LiCl(12H2O)";

//==================================
//Equation section
equation
deltaH = deltaH1+deltaH2;

end Ex12_4;
//==================================================================================