//J M Smith, H C Van Ness and M M Abbott;Introduction to Chemical Engineering Thermodynamics; 7th Edition. 

//Chapter-12:Solution Thermodynamics: Applications
//Example: 12.5 Page 458
//Title: Calculate heat transfer rate with LiCl solution in evaporator
//==================================================================================
model Ex12_5

//==================================
//Parameter section
parameter Real Tf(unit="K")=298.15 "Feed temperature";
parameter Real T(unit="K")=405.15 "Boiling point of 40% LiCl";
parameter Real H_LiCl_a(unit="J/s mol")=-33800 "Enthalpy of LiCl in step a";
parameter Real H_LiCl_b(unit="J/s mol")=-23260 "Enthalpy of LiCl in step b";
parameter Real cp(unit="kJ/kg K")=2.72 "Specific heat of LiCl solution";
parameter Real x1(unit="")=0.15 "Composition of inlet";
parameter Real x2(unit="")=0.40 "Composition of outlet";
parameter Real m(unit="kg/s")=2 "Feed flow rate";

//==================================
//Variable section
Real deltaH_a(unit="J/s") "Enthalpy change in step a";
Real deltaH_b(unit="J/s") "Enthalpy change in step b";
Real deltaH_c(unit="J/s") "Enthalpy change in step c";
Real deltaH_d(unit="J/s") "Enthalpy change in step d";
Real n_LiCl_a(unit="mol") "Moles of LiCl in step a";
Real n_LiCl_b(unit="mol") "Moles of LiCl in step b";
Real n_H2O_a(unit="mol") "Moles of H2O in step a";
Real n_H2O_b(unit="mol") "Moles of H2O in step b";
Real m_LiCl_c(unit="kg") "Mass of LiCl in step c";
Real m_H2O_d(unit="kg") "Mass of H2O in step a";
Real deltaH(unit="J/s") "Overall enthalpy change";

//==================================
//Equation section
equation
//Step a
n_LiCl_a = x1*m*1000/42.39; //Molecular weight of LiCl = 42.39
n_H2O_a = (1-x1)*m*1000/18.015;  //Molecular weight of LiCl = 18.015
deltaH_a = n_LiCl_a*H_LiCl_a;
//Step b
n_LiCl_b = x1*m*1000/42.39;
n_H2O_b = (x1*m*(1-x2))/(x2)*1000/18.015;
deltaH_b = n_LiCl_b*H_LiCl_b;
//Step c
m_LiCl_c = 0.75;
deltaH_c = m_LiCl_c*cp*1000*(T-Tf);
//Step d
m_H2O_d = 2-m_LiCl_c;
deltaH_d = m_H2O_d*1000*(2740.3-104.8); //from steam tables
deltaH = deltaH_a+deltaH_b+deltaH_c+deltaH_d;
//The answer may slightly vary due to rounding off values

end Ex12_5;
//==================================================================================