//J M Smith, H C Van Ness and M M Abbott;Introduction to Chemical Engineering Thermodynamics; 7th Edition. 

//Chapter-13:Chemical-Reaction Equilibria
//Example: 13.14 Page 527
//Title: Calculate the equilibrium compositions
//==================================================================================
model Ex13_14

//==================================
//Parameter section
parameter Real T(unit="K")=1000 "Temperature of reaction";
parameter Real P(unit="bar")=1 "Pressure of reaction";
parameter Real R(unit="J/mol K")=8.314 "Universal gas constant";
parameter Real deltaGf_CH4(unit="J/mol")=19720 "Change in Gibbs free energy of formation of CH4";
parameter Real deltaGf_H2O(unit="J/mol")=-192420 "Change in Gibbs free energy of formation of H2O";
parameter Real deltaGf_CO(unit="J/mol")=-200240 "Change in Gibbs free energy of formation of CO";
parameter Real deltaGf_CO2(unit="J/mol")=-395790 "Change in Gibbs free energy of formation of CO2";
parameter Real deltaGf_H2(unit="J/mol")=0 "Change in Gibbs free energy of formation of H2";
parameter Real ni_CH4(unit="mol")=2 "Initial number of mole of CH4";
parameter Real ni_H2O(unit="mol")=3 "Initial number of mole of H2O";

//==================================
//Variable section
Real y_CH4(unit="") "Mole fraction of CH4";
Real y_H2O(unit="") "Mole fraction of H2";
Real y_CO(unit="") "Mole fraction of CO";
Real y_CO2(unit="") "Mole fraction of CO2";
Real y_H2(unit="") "Mole fraction of H2";
Real lam_CbyRT(unit="") ;
Real lam_ObyRT(unit="") ;
Real lam_HbyRT(unit="") ;
Real n_CO(start=1) "Moles of CO";
Real n_CO2(start=1) "Moles of CO2";
Real n_H2(start=1) "Moles of H2";
Real n_CH4(start=1) "Moles of CO2";
Real n_H2O(start=1) "Moles of H2";
Real sum_n(unit="mol") "Total moles";

//==================================
//Equation section
equation
sum_n = (n_CH4+n_CO+n_CO2+n_H2O+n_H2);

deltaGf_CH4/(R*T)+log(n_CH4/sum_n)+lam_CbyRT+4*lam_HbyRT = 0;
deltaGf_H2O/(R*T)+log(n_H2O/sum_n)+2*lam_HbyRT+lam_ObyRT = 0;
deltaGf_CO/(R*T)+log(n_CO/sum_n)+lam_CbyRT+lam_ObyRT = 0;
deltaGf_CO2/(R*T)+log(n_CO2/sum_n)+lam_CbyRT+2*lam_ObyRT = 0;
deltaGf_H2/(R*T)+log(n_H2/sum_n)+2*lam_HbyRT = 0;

n_CH4+n_CO+n_CO2=ni_CH4;
4*n_CH4+2*n_H2O+2*n_H2 = 4*ni_CH4+2*ni_H2O;
n_H2O+n_CO+2*n_CO2 = ni_H2O;

y_CO = n_CO/sum_n;
y_CO2 = n_CO2/sum_n;
y_H2 = n_H2/sum_n;
y_CH4 = n_CH4/sum_n;
y_H2O = n_H2O/sum_n;


end Ex13_14;
//==================================================================================
