//J M Smith, H C Van Ness and M M Abbott;Introduction to Chemical Engineering Thermodynamics; 7th Edition. 

//Chapter-13:Chemical-Reaction Equilibria
//Example: 13.6 Page 504
//Title: Calculate the maximum conversion of ethylene to ethanol
//==================================================================================
model Ex13_6

//==================================
//Parameter section
parameter Real P(unit="kPa")=35 "Pressure of system";
parameter Real T1(unit="K")=523.15 "Temperature of reaction";
parameter Real T0(unit="K")=298.15 "Reference temperature";
parameter Real A_C2H4(unit="")=1.424 "Cp constants";
parameter Real B_C2H4(unit="")=0.014394 "Cp constants";
parameter Real C_C2H4(unit="")=-0.000004392 "Cp constants";
parameter Real D_C2H4(unit="")=0 "Cp constants";
parameter Real A_H2O(unit="")=3.47 "Cp constants";
parameter Real B_H2O(unit="")=0.00145 "Cp constants";
parameter Real C_H2O(unit="")=0 "Cp constants";
parameter Real D_H2O(unit="")=12100 "Cp constants";
parameter Real A_C2H5OH(unit="")=3.518 "Cp constants";
parameter Real B_C2H5OH(unit="")=0.020001 "Cp constants";
parameter Real C_C2H5OH(unit="")=-0.000006002 "Cp constants";
parameter Real D_C2H5OH(unit="")=0 "Cp constants";
parameter Real H_C2H4(unit="J/mol")=52510 "Enthalpy of component";
parameter Real G_C2H4(unit="J/mol")=68460 "Gibbs free energy of component";
parameter Real H_H2O(unit="J/mol")=-241818 "Enthalpy of component";
parameter Real G_H2O(unit="J/mol")=-228572 "Gibbs free energy of component";
parameter Real H_C2H5OH(unit="J/mol")=-235100 "Enthalpy of component";
parameter Real G_C2H5OH(unit="J/mol")=-168490 "Gibbs free energy of component";
parameter Real R(unit="J/mol K")=8.314 "Universal gas constant";
parameter Real[3] Tc(unit="K")={282.3,647.1,513.9} "Critical temperatures";
parameter Real[3] Pc(unit="K")={50.40,220.55,61.48} "Critical pressures";
parameter Real[3] omega(unit="")={0.087,0.345,0.645} ;
parameter Real ratio(unit="")=5 "Ratio of steam to ethylene";

//==================================
//Variable section
Real deltaA(unit="") "Cp constants";
Real deltaB(unit="") "Cp constants";
Real deltaC(unit="") "Cp constants";
Real deltaD(unit="") "Cp constants";
Real deltaH(unit="J/mol") "Change in enthalpy in reaction at 298.15 K";
Real deltaG(unit="J/mol") "Change in Gibbs free energy at 298.15 K";
Real deltaGbyRT1(unit="") "Change in Gibbs free energy/(R*T1) at 523.15 K";
Real K(unit="") "Equilibrium constant at 523.15 K";
Real I1(unit="") "Integral values";
Real I2(unit="") "Integral values";
Real[3] Tr(unit="K") "Reduced temperature";
Real[3] Pr(unit="K") "Reduced pressure";
Real Y(unit="") "Composition ratio";
Real[3] B0(unit="") ;
Real[3] B1(unit="") ;
Real[3] phi(unit="") ;
Real eps(unit="") "Maximum conversion";

//==================================
//Equation section
equation
deltaA = A_C2H5OH-A_C2H4-A_H2O;
deltaB = B_C2H5OH-B_C2H4-B_H2O;
deltaC = C_C2H5OH-C_C2H4-C_H2O;
deltaD = D_C2H5OH-D_C2H4-D_H2O;
deltaH = H_C2H5OH-H_C2H4-H_H2O;
deltaG = G_C2H5OH-G_C2H4-G_H2O;
I2 = deltaA*log(T1/T0)+(deltaB*T0+(deltaC*T0^2+deltaD/((T1/T0)^2*T0^2))*((T1/T0)+1)/2)*((T1/T0)-1);
I1 = (deltaA*T0*((T1/T0)-1)+deltaB/2*T0^2*((T1/T0)^2-1)+deltaC/3*T0^3*((T1/T0)^3-1)+deltaD/T0*((T1/T0)-1)/(T1/T0));
deltaGbyRT1 = (deltaG-deltaH)/(R*T0)+deltaH/(R*T1)+I1/T1-I2;
K = exp(-deltaGbyRT1);
for i in 1:3 loop
Tr[i] = T1/Tc[i];
Pr[i] = P/Pc[i];
B0[i] = 0.083-0.422/Tr[i]^1.6;
B1[i] = 0.139-0.172/Tr[i]^4.2;
phi[i] = exp(Pr[i]/Tr[i]*(B0[i]+omega[i]*B1[i]));
end for;
Y = phi[1]*phi[2]/phi[3]*P*K;
Y = eps*(6-eps)/((5-eps)*(1-eps));

end Ex13_6;
//==================================================================================
