//J M Smith, H C Van Ness and M M Abbott;Introduction to Chemical Engineering Thermodynamics; 7th Edition. 

//Chapter-13:Chemical-Reaction Equilibria
//Example: 13.7 Page 505
//Title: Calculate the composition of product stream at equilibrium 
//==================================================================================
model Ex13_7

//==================================
//Parameter section
parameter Real T(unit="K")=373.15 "Temperature of reaction";
parameter Real K_I(unit="")=4e5 "Equilibrium constant of reaction I";
parameter Real K_II(unit="")=2.5e-6 "Equilibrium constant of reaction II";
parameter Real P0(unit="bar")=1 "Pressure of system";
parameter Real P(unit="bar")=1 "Reference Pressure";

//==================================
//Variable section
Real K(unit="") "Equilibrium constant of overall reaction";
Real Y(unit="") "Ratio of compositions";
Real y_H2(unit="mol") "Number of moles of H2";
Real y_C2H2(unit="mol") "Number of moles of C2H2";
Real y_C2H4(unit="mol") "Number of moles of C2H4";
Real eps(unit="") "Maximum conversion";

//==================================
//Equation section
equation
K = K_I*K_II;
Y =  K*(P/P0);
eps*(2-eps)/(1-eps)^2 = Y;
y_H2 = (1-eps)/(2-eps);
y_C2H2 = y_H2;
y_C2H4 = eps/(2-eps);

end Ex13_7;
//==================================================================================