//J M Smith, H C Van Ness and M M Abbott;Introduction to Chemical Engineering Thermodynamics; 7th Edition. 

//Chapter-13:Chemical-Reaction Equilibria
//Example: 13.8 Page 507
//Title: Calculate the mole fraction of ethyl acetate in equilibrium
//==================================================================================
model Ex13_8

//==================================
//Parameter section
parameter Real T1(unit="K")=373.15 "Temperature of reaction";
parameter Real T0(unit="K")=298.15 "Reference temperature";
parameter Real H_EtAc(unit="J/mol")=-480000 "Enthalpy of component";
parameter Real G_EtAc(unit="J/mol")=-332200 "Gibbs free energy of component";
parameter Real H_H2O(unit="J/mol")=-285830 "Enthalpy of component";
parameter Real G_H2O(unit="J/mol")=-237130 "Gibbs free energy of component";
parameter Real H_AcH(unit="J/mol")=-484500 "Enthalpy of component";
parameter Real G_AcH(unit="J/mol")=-389900 "Gibbs free energy of component";
parameter Real H_EtOH(unit="J/mol")=-277690 "Enthalpy of component";
parameter Real G_EtOH(unit="J/mol")=-174780 "Gibbs free energy of component";
parameter Real R(unit="J/mol K")=8.314 "Universal gas constant";

//==================================
//Variable section
Real deltaH_298(unit="J/mol") "Change in enthalpy in reaction at 298.15 K";
Real deltaG_298(unit="J/mol") "Change in Gibbs free energy at 298.15 K";
Real K_298(unit="") "Equilibrium constant at 298.15 K";
Real K_373(unit="") "Equilibrium constant at 373.15 K";
Real eps(unit="") "Maximum conversion";
Real x_AcH(unit="mol") "Number of moles of acetic acid";
Real x_EtOH(unit="mol") "Number of moles of ethanol";
Real x_H2O(unit="mol") "Number of moles of water";
Real x_EtAc(unit="mol") "Number of moles of ethyl acetate";

//==================================
//Equation section
equation
deltaH_298 = H_EtAc+H_H2O-H_AcH-H_EtOH;
deltaG_298 = G_EtAc+G_H2O-G_AcH-G_EtOH;
log(K_298) = -deltaG_298/(R*T0);
(K_373/K_298) = exp(-deltaH_298/R*(1/T1-1/T0));
K_373 = eps^2/(1-2*eps+eps^2);
x_AcH =  (1-eps)/2;
x_EtOH = x_AcH;
x_EtAc = eps/2;
x_H2O = x_EtAc;

end Ex13_8;
//==================================================================================