//J M Smith, H C Van Ness and M M Abbott;Introduction to Chemical Engineering Thermodynamics; 7th Edition.

//Chapter-14:Topics in Phase Equilibria
//Example: 14.8 Page 592
//Title: Discuss the phase equilibrium data
//==================================================================================

model Ex14_8
//==================================
//Parameter section
parameter Real T(unit="K")=308.15 "Temperature of system";
parameter Real A21=3.35629;
parameter Real A12=4.62424;
parameter Real alpha12=3.78608;
parameter Real alpha21=1.81775;
parameter Real B11=-996;
parameter Real B22=-1245;
parameter Real B12=-567;
parameter Real P1s(unit="kPa")=103.264 "Saturation pressure of component 1";
parameter Real P2s(unit="kPa")=5.633 "Saturation pressure of component 2";
parameter Real R(unit="J/ mol K")=8.314 "Univeral gas constant";

//==================================
//Variable section
Real[9] x1(unit="") "Mole fraction of component 1";
Real[9] x2(unit="") "Mole fraction of component 2";
Real[9] Q;
Real[9] dQbydx;
Real[9] gamma1(unit="") "Activity coefficient";
Real[9] gamma2(unit="") "Activity coefficient";
Real[9] GE(unit="J/mol") "Free energy";
Real P_ast(unit="kPa");
Real y1_ast(unit="");

//==================================
//Equation section
equation
x1 = {0.0117,0.2,0.3,0.4,0.5,0.6,0.7,0.9,0.95};
for i in 1:9 loop
x2[i] = 1-x1[i];
Q[i] = alpha12*x1[i]*alpha21*x2[i]/(alpha12*x1[i]+alpha21*x2[i]);
dQbydx[i] = alpha12*alpha21*(alpha21*x2[i]^2-alpha12*x1[i]^2)/(alpha12*x1[i]+alpha21*x2[i])^2;
GE[i]/(x1[i]*x2[i]*R*T) = A21*x1[i]+A12*x2[i]-Q[i];
log(gamma1[i]) = x2[i]^2*(A12+2*(A21-A12)*x1[i]-Q[i]-x1[i]*dQbydx[i]);
log(gamma2[i]) = x1[i]^2*(A21+2*(A12-A21)*x2[i]-Q[i]-x2[i]*dQbydx[i]);
end for;
P_ast = x1[9]*gamma1[9]*P1s+x2[1]*gamma2[1]*P2s;
y1_ast = x1[9]*gamma1[9]*P1s/P_ast;

end Ex14_8;
//==================================================================================
