//J M Smith, H C Van Ness and M M Abbott;Introduction to Chemical Engineering Thermodynamics; 7th Edition.

//Chapter-14:Topics in Phase Equilibria
//Example: 14.9 Page 596
//Title: Prepare a table of temperature composition data
//==================================================================================

model Ex14_9
//==================================
//Parameter section
parameter Real P(unit="kPa")=101.33 "Pressure of system";
parameter Real[7] T(unit="K")={333.15,343.15,348.15,353.15,363.25,363.15,373.15} "Temperature of system";
parameter Real[7] P1s(unit="kPa")={52.22,73.47,86.40,101.05,101.33,136.14,180.04} "Vapor pressure of component 1";
parameter Real[7] P2s(unit="kPa")={19.92,31.16,38.55,47.36,47.56,70.11,101.33} "Vapor pressure of component 2";

//==================================
//Variable section
Real[7] P1splusP2s(unit="kPa") "Sum of vapor pressures";
Real[7] y1_II(unit="");
Real[7] y1_I(unit="");
Real T_ast(unit="K") ;
Real y_ast(unit="");
Real P1s_ast(unit="kPa");

//==================================
//Equation section
equation
for i in 1:7 loop
P1splusP2s[i] = P1s[i]+P2s[i];
end for;
T_ast = T[1] + (P-P1splusP2s[1])/(P1splusP2s[2]-P1splusP2s[1])*(T[2]-T[1]);
P1s_ast = P1s[1] + (P-P1splusP2s[1])/(P1splusP2s[2]-P1splusP2s[1])*(P1s[2]-P1s[1]);
 //using interpolation formula
y_ast = P1s_ast/P;
for i in 1:7 loop
y1_II[i] = 1-P2s[i]/P;
if(P1s[i]/P<=1) then y1_I[i] = P1s[i]/P; else y1_I[i] = 0; end if;
end for;
end Ex14_9;
//The answer table given in the book is produced here in ascending order of temperature
//==================================================================================
