//J M Smith, H C Van Ness and M M Abbott;Introduction to Chemical Engineering Thermodynamics; 7th Edition. 

//Chapter-2:The First Law and Other Basic Concepts
//Example: 2.10 Page 43
//Title: Calculate the internal energy and enthalpy changes in air
//==================================================================================
model Ex2_10

//==================================
//Parameter section
parameter Real T1(unit = "K") = 277 "Initial temperature";
parameter Real P1(unit = "bar") = 10 "Initial pressure";
parameter Real V1(unit = "m3/mole") = 2.28 "Initial molar volume";
parameter Real T2(unit = "K") = 333 "Final temperature";
parameter Real P2(unit = "atm") = 1 "Final pressure"; 
parameter Real Cv(unit = "") = 21 "Heat capacity at constant volume of air";
parameter Real Cp(unit = "J/(mol K)") = 29.3 "Heat capacity at constant pressure of air";

//==================================
//Variable section
Real T(unit = "K") "Intermediate temperature";
Real deltaTa(unit = "K") "Temperature change in step a";
Real deltaTb(unit = "K") "Temperature change in step b";
Real deltaUa(unit = "kJ/kmole") "Internal energy change in step a";
Real deltaUb(unit = "kJ/kmole") "Internal energy change in step b";
Real deltaHa(unit = "kJ/kmole") "Enthalpy change in step a";
Real deltaHb(unit = "kJ/kmole") "Enthalpy change in step b";
Real V2(unit = "m3") "Final volume of air";
Real deltaU(unit = "kJ/kmole") "Internal energy change";
Real deltaH(unit = "kJ/kmole") "Enthalpy change";

//==================================
//Equation section
equation
T = T1/P1;
deltaTa = T-T1;
deltaTb = T2-T;
deltaUa = Cv*deltaTa;
deltaHa = deltaUa+V1*(P2-P1)*10^2;//to convert bar to kPa;
V2 = V1*P1*T2/(P2*T1);
deltaHb = Cp*deltaTb;
deltaUb = deltaHb-P2*10^2*(V2-V1);
deltaU = deltaUa+deltaUb;
deltaH = deltaHa+deltaHb;

end Ex2_10;
//==================================================================================