//J M Smith, H C Van Ness and M M Abbott;Introduction to Chemical Engineering Thermodynamics; 7th Edition. 

//Chapter-2:The First Law and Other Basic Concepts
//Example: 2.17 Page 54
//Title: Calculate temperature of water delivered to second tank 
//==================================================================================
model Ex2_17

//==================================
// Library section
extends Modelica.Constants ;

//==================================
//Parameter section
parameter Real T1(unit = "K")=366.65 "Initial temperature";
parameter Real V(unit = "m3/s")=3.15*10^(-3) "Volumetric rate of water";
parameter Real q(unit = "kW")=700 "Heat given up by heat exchanger";
parameter Real work(unit = "kW")=1.5 "Work supplied by pump";
parameter Real deltaz(unit = "m")=15 "Elevation of second tank from first tank";

//==================================
//Variable section
Real Q(unit = "kJ/kg") "Heat change in heat exchanger";
Real T2(unit = "K") "Final temperature";
Real Ws(unit = "kJ/kg") "Work supplied by pump";
Real deltaH(unit = "kJ/kg") "Enthalpy change";
Real H1(unit = "kJ/kg") "Enthalpy of steam at T=T1";
Real H2(unit = "kJ/kg") "Enthalpy of steam at T=T2";
Real mdot(unit = "kg/s") "Mass flow rate";

//==================================
//Equation section
equation
mdot = V*958; //Density of water at T1=958kg/m^3
Q = -q/mdot; //Negative sign since heat is lost
Ws = work/mdot;
H1 = 391.6; //Enthalpy corresponding to T1 taken from steam tables
deltaH = Q+Ws-(deltaz*g_n/1000);
deltaH = H2-H1;
T2=311.35;//Temperature corresponding to H2 is taken from steam tables as T2

end Ex2_17;
//==================================================================================