//J M Smith, H C Van Ness and M M Abbott;Introduction to Chemical Engineering Thermodynamics; 7th Edition. 

//Chapter-2:The First Law and Other Basic Concepts
//Example: 2.3 Page 27
//Title: Find the energy change in a system
//==================================================================================
//Note: The below problem is linked to Example 2.2(theory) 
model Ex2_3

//==================================
//Parameter section
parameter Real V1(unit = "m3") =0.1 "Initial volume of cylinder";
parameter Real Patm(unit = "kPa") =101.325 "Pressure of surrounding";

//==================================
//Variable section
Real W(unit = "kJ") "Work done by the system on the surroundings";
Real deltaE(unit = "kJ") "Energy change of the system";
Real V2(unit = "m3") "Final volume of cylinder";

//==================================
//Equation section
equation
V2 = 2*V1;//given
W = -Patm*(V2-V1);//definition of work
deltaE = W;//no heat transfer takes place

end Ex2_3;
//==================================================================================