package Ex2_4
  function Internal_energy
    input Real Q;
    input Real W;
    output Real U;
  algorithm
    U := Q + W;
  end Internal_energy;

  //J M Smith, H C Van Ness and M M Abbott;Introduction to Chemical Engineering Thermodynamics; 7th Edition.
  //Chapter-2:The First Law and Other Basic Concepts
  //Example: 2.4 Page 28
  //Title: Calculate heat flow and work done
  //==================================================================================

  model Ex2_4
    //==================================
    //Parameter section
    parameter Real Qacb(unit = "J") = 100 "Heat flow along path acb";
    parameter Real Wacb(unit = "J") = -40 "Work done along path acb";
    parameter Real Waeb(unit = "J") = -20 "Work done along path aeb";
    parameter Real Wbda(unit = "J") = 30 "Work done along path bda";
    //==================================
    //Variable section
    Real deltaUab(unit = "J") "Total internal energy change";
    Real Qaeb(unit = "J") "Heat flow along path acb";
    Real Qbda(unit = "J") "Heat flow along path bda";
    //==================================
    //Equation section
  equation
    deltaUab = Internal_energy(Qacb, Wacb);
    deltaUab = Internal_energy(Qaeb, Waeb);
    -deltaUab = Internal_energy(Qbda, Wbda);
//deltaUba=-deltaUab
  end Ex2_4;

  //==================================================================================
end Ex2_4;