//J M Smith, H C Van Ness and M M Abbott;Introduction to Chemical Engineering Thermodynamics; 7th Edition. 

//Chapter-2:The First Law and Other Basic Concepts
//Example: 2.6 Page 35
//Title: Find the work done by gas 
//==================================================================================
model Ex2_6

//==================================
//Parameter section
parameter Real Vt1(unit = "m3") =0.03 "Initial volume of cylinder";
parameter Real P1(unit = "bar") =14 "Initial pressure of cylinder"; 

//==================================
//Variable section
Real Vt2(unit = "m3") "Final volume of cylinder";
Real P2(unit = "Pa") "Final pressure of cylinder";
Real k(unit = "J") "Constant=PVt";
Real W1(unit = "J") "Work done by gas in reversible process";
Real W2(unit = "J") "Work done by gas in irreversible process";
Real efficiency(unit = "%") "Efficiency of irreversible to reversible process";

//==================================
//Equation section
equation
Vt2 = 2*Vt1;//given
k = P1*100000*Vt1;//convert bar to Pa
W1 = -k*log(Vt2/Vt1);//integrate work equation
P2 = k/Vt2;
W2 = -P2*(Vt2-Vt1);
efficiency = (W2/W1)*100;

end Ex2_6;
//==================================================================================