//J M Smith, H C Van Ness and M M Abbott;Introduction to Chemical Engineering Thermodynamics; 7th Edition. 

//Chapter-3:Volumetric properties of pure fluids
//Example: 3.4 Page 83
//Title: Calculate energy changes in an irreversible process 
//==================================================================================
model Ex3_4

//==================================
//Parameter section
parameter Real P1(unit = "bar") = 1 "Initial pressure of system";
parameter Real T1(unit = "K") =343.15  "Initial temperature of system";
parameter Real T2(unit = "K") =423.15 "Final temperature of system";
parameter Real R(unit = "J/(mol K)") =8.314 "Universal gas constant";
parameter Real E(unit = "") =0.80 "Efficiency of system";

//==================================
//Variable section
Real cp(unit = "J/(mol K)") "Constant pressure heat capacity";
Real gamma(unit = "J/(mol K)") "cp/cv";
Real cv(unit = "") "Constant volume heat capacity";
Real P2(unit = "K") "Final adiabatic temperature of system";
Real Qa(unit = "J") "Heat transferred in a";
Real Wa(unit = "J") "Work required in a";
Real deltaUa(unit = "J") "Change in internal energy in a";
Real deltaHa(unit = "J") "Change in enthalpy in a";
Real Qb(unit = "J") "Heat transferred in b";
Real Wb(unit = "J") "Work required in b";
Real deltaUb(unit = "J") "Change in internal energy in b";
Real deltaHb(unit = "J") "Change in enthalpy in b";
Real Qc(unit = "J") "Heat transferred in c";
Real Wc(unit = "J") "Work required in c";
Real deltaUc(unit = "J") "Change in internal energy in c";
Real deltaHc(unit = "J") "Change in enthalpy in C";
Real Q(unit = "J") "Overall heat transferred";
Real W(unit = "J") "Overall work required";
Real deltaU(unit = "J") "Overall change in internal energy";
Real deltaH(unit = "J") "Overall change in enthalpy";

//==================================
//Equation section
equation
cp = (5/2)*R;
cv = (3/2)*R;
//a
deltaUa = cv*(T2-T1);
deltaHa = cp*(T2-T1);
Wa = deltaUa/E;
Qa = deltaUa-Wa;
//b
deltaHb = cp*(T1-T2);
deltaUb = cv*(T1-T2);
Wb = (deltaUb-deltaHb)/E;
Qb = deltaUb-Wb;
gamma = cp/cv;
P2 = P1*((T2/T1)^(gamma/(gamma-1)));
//c
deltaUc = 0;//for an ideal gas isothermal process
deltaHc = 0;
Wc = (-R*T1*log(P2/P1))*E;
Qc = deltaUc-Wc;
//Overall process
Q = Qa+Qb+Qc;
W = Wa+Wb+Wc;
deltaU = deltaUa+deltaUb+deltaUc;
deltaH = deltaHa+deltaHb+deltaHc;

end Ex3_4;
//==================================================================================