//J M Smith, H C Van Ness and M M Abbott;Introduction to Chemical Engineering Thermodynamics; 7th Edition. 

//Chapter-4:Heat Effects
//Example: 4.4 Page 134
//Title: Calculate latent heat of water
//==================================================================================
model Ex4_4

//==================================
//Parameter section
parameter Real T1(unit = "K") =373.15 "Temperature of known latent heat";
parameter Real T2(unit = "K") =573.15 "Temperature of unknown latent heat";
parameter Real deltaH1(unit = "J/g") =2257 "Latent heat at Tr1";

//==================================
//Variable section
Real Tr1(unit = "K") "Reduced temperature of known latent heat";
Real Tr2(unit = "K") "Reduced temperature of unknown latent heat";
Real deltaH2(unit = "J/g") "Latent heat at Tr2";

//==================================
//Equation section
equation
Tr1 = T1/647.1;
Tr2 = T2/647.1;
deltaH2 = deltaH1*((1-Tr2)/(1-Tr1))^0.38; //Watson method

end Ex4_4;
//==================================================================================