//J M Smith, H C Van Ness and M M Abbott;Introduction to Chemical Engineering Thermodynamics; 7th Edition. 

//Chapter-4:Heat Effects
//Example: 4.5 Page 138
//Title: Calculate standard heat of reaction
//==================================================================================
model Ex4_5

//==================================
//Parameter section
parameter Real T(unit = "K") =298.15 "Temperature of reaction";

//==================================
//Variable section
Real deltaH_HCl(unit = "J") "Heat of formation of HCl";
Real deltaH_H2O(unit = "J") "Heat of formation of H2O";
Real deltaH1(unit = "J") "Heat of formation of 4HCl-->2H2+2Cl2";
Real deltaH2(unit = "J") "Heat of formation of 2H2+O2-->2H2O";
Real deltaHc(unit = "J") "Heat of overall reaction";

//==================================
//Equation section
equation
deltaH_HCl = -92307;
deltaH_H2O = -241818;//from Table C.4
//4HCl --> 2H2+2Cl2
//2H2+O2 --> 2H2O
deltaH1 = 4*(-deltaH_HCl);
deltaH2 = 2*deltaH_H2O;
deltaHc = deltaH1+deltaH2;

end Ex4_5;
//==================================================================================