//J M Smith, H C Van Ness and M M Abbott;Introduction to Chemical Engineering Thermodynamics; 7th Edition. 

//Chapter-5:The second law of thermodynamics
//Example: 5.6 Page 178
//Title: Check if the process is feasible
//==================================================================================
model Ex5_6

//==================================
//Parameter section
parameter Real Ts(unit="K")=373.15 "Temperature of saturated steam";
parameter Real Tr(unit="K")=473.15 "Reported temperature provided by process";
parameter Real Tsigma(unit="K")=273.15 "Temperature of cooling water";
parameter Real Qr(unit="kJ")=2000 "Reported energy liberated";
parameter Real H1(unit="kJ/kg")=2676 "Enthalpy at 373.15 K from Appendix F";
parameter Real S1(unit="kJ/kg")=7.3554 "Entropy at 373.15 K from Appendix F";
parameter Real H2(unit="kJ/kg")=0 "Enthalpy at 273.15 K from Appendix F";
parameter Real S2(unit="kJ/kg")=0 "Entropy at 273.15 K from Appendix F";

//==================================
//Variable section
Real Qsigma(unit="kJ") "Surrounding heat transfer";
Real deltaS(unit="kJ/K") "Enthalpy change of steam";
Real deltaS_tot(unit="kJ/K") "Total enthalpy change of process";
Real deltaS_1(unit="kJ/K") "Enthalpy change for heat reservoir at 473.15 K";
Real deltaS_2(unit="kJ/K") "Enthalpy change for heat reservoir at 273.15 K";
Real Qdash(unit="kJ") "Actual heat released";

//==================================
//Equation section
equation
Qsigma = (H2-H1)+Qr;//first law of thermodynamics
deltaS = S2-S1;
deltaS_1 = Qr/Tr;
deltaS_2 = -Qsigma/Tsigma;
deltaS_tot = deltaS+deltaS_1+deltaS_2;//if it is negative, the process is impossible
Qdash = Tr/(Tr-Tsigma)*((H2-H1)-Tsigma*deltaS);

end Ex5_6;
//==================================================================================