//J M Smith, H C Van Ness and M M Abbott;Introduction to Chemical Engineering Thermodynamics; 7th Edition. 

//Chapter-5:The second law of thermodynamics
//Example: 5.9 Page 186
//Title: Countercurrent and cocurrent heatflow
//==================================================================================
model Ex5_9

//==================================
//Parameter section
parameter Real TH1(unit="K")=400 "Hot fluid inlet temperature";
parameter Real TC1(unit="K")=300 "Cold fluid inlet temperature";
parameter Real TH2(unit="K")=350 "Hot fluid outlet temperature";
parameter Real deltaT(unit="K")=10 "Minimum temperature difference";
parameter Real Tsigma(unit="K")=300 "";
parameter Real R(unit="J/(mol k)")=8.314 "Universal gas constant";
parameter Real nH(unit="mol/s")=1 "Mole rate";

//==================================
//Variable section
Real TC2_a(unit="K") "Cold fluid outlet temperature for cocurrent flow";
Real TC2_b(unit="K") "Cold fluid outlet temperature for countercurrent flow";
Real k1(unit="") "nc/nH for cocurrent flow";
Real k2(unit="") "nc/nH for countercurrent flow";
Real deltarS1(unit="J/(K s)") "Total change in entropy change in cocurrent flow";
Real deltarS2(unit="J/(K s)") "Total change in entropy change in countercurrent flow";
Real Wlost1(unit="W") "Work lost for cocurrent flow";
Real Wlost2(unit="W") "Work lost for countercurrent flow";

//==================================
//Equation section
equation
TC2_a = TH2-deltaT;
k1 = (TH1-TH2)/((TC2_a)-TC1);
deltarS1 = nH*7/2*R*(log(TH2/TH1)+k1*log(TC2_a/TC1));
Wlost1 = Tsigma*deltarS1;
TC2_b = TH1-deltaT;
k2 = (TH1-TH2)/((TC2_b)-TC1);
deltarS2 = nH*7/2*R*(log(TH2/TH1)+k2*log(TC2_b/TC1));
Wlost2 = Tsigma*deltarS2;

end Ex5_9;
//==================================================================================