//J M Smith, H C Van Ness and M M Abbott;Introduction to Chemical Engineering Thermodynamics; 7th Edition. 

//Chapter-6:Thermodynamic properties of fluids
//Example: 6.10 Page 239
//Title: Estimate using Lee/Kesler correlations
//==================================================================================
model Ex6_10

//==================================
//Parameter section
parameter Real T(unit="K")=450 "Temperature of mixture";
parameter Real P(unit="bar")=140 "Pressure of mixture";
parameter Real y1(unit="")=0.5 "Composition of CO2";
parameter Real Tc1(unit="K")=304.2 "Critical temperature of CO2";
parameter Real Tc2(unit="K")=369.8 "Critical temperature of propane";
parameter Real Pc1(unit="bar")=73.83 "Critical pressure of CO2";
parameter Real Pc2(unit="bar")=42.48 "Critical pressure of propane";
parameter Real omega1(unit="")=0.224 "Critical constant of CO2";
parameter Real omega2(unit="")=0.152 "Critical constant of propane";
parameter Real Z0(unit="")=0.697 "Compressibilty factor of mixture";
parameter Real Z1(unit="")=0.205 "Compressibilty factor of mixture";
parameter Real R(unit="J/K mol")=8.314 "Universal gas constant";

//==================================
//Variable section
Real Tpc(unit="K") "Pseudocritical temperature of mixture";
Real Ppc(unit="bar") "Pseudocritical pressure of mixture";
Real Tpr(unit="K") "Pseudoreduced temperature of mixture";
Real Ppr(unit="bar") "Pseudoreduced pressure of mixture";
Real omega(unit="") "Critical constant of mixture";
Real Z(unit="") "Compressibilty factor of mixture";
Real V(unit="cm^3/mol") "Volume of mixture";
Real HR(unit="J/mol") "Reduced enthalpy of mixture";
Real SR(unit="J/mol K") "Reduced entropy of mixture";

//==================================
//Equation section
equation
omega = y1*omega1+(1-y1)*omega2;
Tpc = y1*Tc1+(1-y1)*Tc2;
Ppc = y1*Pc2+(1-y1)*Pc2;
Tpr = T/Tpc;
Ppr = P/Ppc;
Z = Z0+omega*Z1;
V = Z*R*T*10/P;
HR = R*Tpc*(-1.730+(-0.169)*omega);
SR = R*(-0.967+(-0.330)*omega);

end Ex6_10;
//==================================================================================