package Ex6_6
  //J M Smith, H C Van Ness and M M Abbott;Introduction to Chemical Engineering Thermodynamics; 7th Edition.
  //Chapter-6:Thermodynamic properties of fluids
  //Example: 6.6 Page 224
  //Title: Calculate vapor pressure for n-hexane
  //==================================================================================
  //==================================

  model Ex6_6_a
    //==================================
    //Parameter section
    parameter Real[4] T(unit = "K") = {273.15, 303.15, 333.15, 363.15} "Temperature of system";
    //==================================
    //Variable section
    Real Psata[4](unit = "kPa") "Vapor pressure";
    Real j(unit = "") "Control variable";
    //==================================
    //Equation section
  equation
    j = 1;
    for j in 1:4 loop
      log(Psata[j]) = 13.8193 - 2696.04 / (T[j] - 273.15 + 224.317);
    end for;
  end Ex6_6_a;

  //==================================

  model Ex6_6_b
    //==================================
    //Reference section
    extends Ex6_6_a;
    //==================================
    //Parameter section
    parameter Real Prnsat(unit = "") = 0.03350 "Reduced pressure at boiling point";
    parameter Real Trn(unit = "") = 0.6736 "Reduced temperature at boiling point";
    //==================================
    //Variable section
    Real i(unit = "") "Control variable";
    Real omega(unit = "") "Equation constant";
    Real[4] Tr(unit = "") "Reduced temperature";
    Real[4] Psatb(unit = "kPa") "Vapor pressure";
    Real[4] P0rTr(unit = "kPa") "Equation constant";
    Real[4] P1rTr(unit = "kPa") "Equation constant";
    Real P0rTrn(unit = "kPa") "Equation constant";
    Real P1rTrn(unit = "kPa") "Equation constant";
    Real[4] Psatb(unit = "kPa") "Vapor pressure";
    Real[4] Prsat(unit = "kPa") "Reduced vapor pressure";
    
    //==================================
    //Equation section
  equation
    log(P0rTrn) = 5.92714 - 6.09648 / Trn - 1.28862 * log(Trn) + 0.169347 * Trn ^ 6;
    log(P1rTrn) = 15.2518 - 15.6875 / Trn - 13.4721 * log(Trn) + 0.43577 * Trn ^ 6;
    log(Prnsat) = log(P0rTrn) + omega* log(P1rTrn);
    i = 1;
    for i in 1:4 loop
      Tr[i] = T[i] / 507.6;
      log(P0rTr[i]) = 5.92714 - 6.09648 / Tr[i] - 1.28862 * log(Tr[i]) + 0.169347 * Tr[i] ^ 6;
      log(P1rTr[i]) = 15.2518 - 15.6875 / Tr[i] - 13.4721 * log(Tr[i]) + 0.43577 * Tr[i] ^ 6;
      log(Prsat[i]) = log(P0rTr[i]) +omega* log(P1rTr[i]);
      Psatb[i] = Prsat[i] * 30.25*10^2; //multiplied critical pressure in kPa units
    end for;
  end Ex6_6_b;
end Ex6_6;
