//J M Smith, H C Van Ness and M M Abbott;Introduction to Chemical Engineering Thermodynamics; 7th Edition. 

//Chapter-7:Applications of Thermodynamics to Flow Processes
//Example: 7.3 Page 263
//Title: Calculate critical pressure ratio,velocity at throat and discharge pressure
//==================================================================================
model Ex7_3

//==================================
//Parameter section
parameter Real P1(unit="kPa")=700 "Initial pressure";
parameter Real T1(unit="K")=573.15 "Initial temperature";
parameter Real u1(unit="m/s")=30 "Initial velocity";
parameter Real S1(unit="kJ/(kg K)")=7.2997 "Initial entropy";
parameter Real H1(unit="J/kg")=3059800 "Initial enthalpy";
parameter Real V1(unit="cm^3/g")=371.39 "Initial specific volume";
parameter Real M(unit="")=2 "Mach number";
parameter Real R(unit="J/ kmole K")=8314 "Univeral gas constant";
parameter Real gamma(unit="")=1.3 "Ratio of specific heats";

//==================================
//Variable section
Real P2byP1(unit="") "Ratio of initial and discharge pressures";
Real P1V1(unit="J/kg") "Product of initial pressure and volume";
Real uthroat(unit="m/s") "Velocity at throat";
Real udis(unit="m/s") "Velocity at discharge";
Real P2(unit="kPa") "Discharge pressure";

//==================================
//Equation section
equation
P2byP1 = (2/(gamma+1))^(gamma/(gamma-1));
P1V1 = R*T1/18.015;
uthroat^2 = u1^2+2*gamma*P1V1/(gamma-1)*(1-(P2byP1)^((gamma-1)/gamma));
udis = 2*uthroat;
udis^2 = u1^2+2*gamma*P1V1/(gamma-1)*(1-(P2/P1)^((gamma-1)/gamma));
//the answer provided in the book is wrong (300kPa)

end Ex7_3;
//==================================================================================