//J M Smith, H C Van Ness and M M Abbott;Introduction to Chemical Engineering Thermodynamics; 7th Edition. 

//Chapter-7:Applications of Thermodynamics to Flow Processes
//Example: 7.6 Page 269
//Title: Calculate flow rate of steam and its state at discharge
//==================================================================================
model Ex7_6

//==================================
//Parameter section
parameter Real P1(unit="kPa")=8600 "Initial pressure";
parameter Real T1(unit="K")=773.15 "Initial temperature";
parameter Real P2(unit="kPa")=10 "Discharge pressure";
parameter Real Ws(unit="kW")=-56400 "Capacity of steam";
parameter Real S1(unit="kJ/(kg K)")=6.6858 "Initial entropy";
parameter Real H1(unit="kJ/kg")=3391.6 "Initial enthalpy";
parameter Real S2l(unit="kJ/(kg K)")=0.6493 "Discharge liquid entropy";
parameter Real H2l(unit="kJ/kg")=191.8 "Discharge liquid enthalpy";
parameter Real S2v(unit="kJ/(kg K)")=8.1511 "Discharge vapor entropy";
parameter Real H2v(unit="kJ/kg")=2584.8 "Discharge vapor enthalpy";
parameter Real n(unit="")=0.75 "Efficiency";

//==================================
//Variable section
Real H2d(unit="kJ/kg") "Wet discharge enthalpy with efficiency as 1";
Real S2d(unit="kJ/kg") "Wet discharge entropy with efficiency as 1";
Real H2(unit="kJ/kg") "Actual discharge enthalpy";
Real S2(unit="kJ/kg") "Actual discharge entropy";
Real deltaH(unit="kJ/kg") "Actual change in enthalpy";
Real deltaHs(unit="kJ/kg") "Change in enthalpy with efficiency as 1";
Real m(unit="kg/s") "Mass flow rate of steam";
Real x2d(unit="") "Mole fraction if efficiency was 1";
Real x2(unit="") "Actual mole fraction of discharge";

//==================================
//Equation section
equation
S2d = S1;
S2d = S2l+x2d*(S2v-S2l);
H2d = H2l+x2d*(H2v-H2l);
deltaHs = H2d-H1;
deltaH = n*deltaHs;
H2 = H1+deltaH;
H2 = H2l+x2*(H2v-H2l);
S2 = S2l+x2*(S2v-S2l);
Ws = m*(H2-H1);

end Ex7_6;
//==================================================================================