//J M Smith, H C Van Ness and M M Abbott;Introduction to Chemical Engineering Thermodynamics; 7th Edition. 

//Chapter-7:Applications of Thermodynamics to Flow Processes
//Example: 7.8 Page 274
//Title: Calculate work required in a compressor
//==================================================================================
model Ex7_8

//==================================
//Parameter section
parameter Real P1(unit="kPa")=100 "Initial pressure";
parameter Real P2(unit="kPa")=300 "Discharge pressure";
parameter Real n(unit="")=0.75 "Compressor efficiency";
parameter Real S1(unit="kJ/(kg K)")=7.3598 "Initial entropy";
parameter Real H1(unit="kJ/kg")=2675.4 "Initial enthalpy";

//==================================
//Variable section
Real deltaHs(unit="kJ/kg") "Ideal change in enthalpy";
Real deltaH(unit="kJ/kg") "Actual change in enthalpy";
Real H2d(unit="kJ/kg") "Ideal final enthalpy";
Real H2(unit="kJ/kg") "Final enthalpy";
Real Ws(unit="J/mol") "Isentropic work";
Real T2(unit="K") "Discharge temperature";
Real S2(unit="kJ/(kg K)") "Final entropy";

//==================================
//Equation section
equation
H2d = 2888.8; //By interpolation of tables at 300 kPa supersaturates steam
deltaHs = H2d-H1;
deltaH = deltaHs/n;
H2 = H1+deltaH;
T2 = 519.25;
S2 = 7.5019;//for superheated steam with H2 as enthalpy
Ws = deltaH;

end Ex7_8;
//==================================================================================