//J M Smith, H C Van Ness and M M Abbott;Introduction to Chemical Engineering Thermodynamics; 7th Edition. 

//Chapter-7:Applications of Thermodynamics to Flow Processes
//Example: 7.9 Page 276
//Title: Calculate work required for compressing methane 
//==================================================================================
model Ex7_9

//==================================
//Parameter section
parameter Real P1(unit="kPa")=140 "Initial pressure";
parameter Real T1(unit="K")=293.15 "Initial temperature";
parameter Real P2(unit="kPa")=560 "Discharge pressure";
parameter Real n(unit="")=0.75 "Compressor efficiency";
parameter Real A(unit="")=1.702 "cp constants";
parameter Real B(unit="")=9.081E-3 "cp constants";
parameter Real C(unit="")=-2.164E-6 "cp constants";
parameter Real D(unit="")=0 "cp constants";
parameter Real R(unit="J/ mol K")=8.314 "Univeral gas constant";

//==================================
//Variable section
Real Cp__d_S(unit="J/K mol") "Heat capacity";
Real Cp__d_H(unit="J/K mol") "Heat capacity";
Real Cp_H(unit="J/K mol") "Heat capacity";
Real T2_d(unit="K") "Final temperature";
Real T2(unit="K") "Final temperature";
Real Ws_iso(unit="J/mol") "Isentropic work";
Real Ws(unit="J/mol") "Actual work";
Real tau_d(unit="") "Temperature ratio";
Real tau(unit="") "Temperature ratio";

//==================================
//Equation section
equation
tau_d = T2_d/T1;
Cp__d_S = R*(A+(B*T1+(C*T1^2+D/T2_d^2)*(tau_d+1)/2)*(tau_d-1)/log(tau_d));
T2_d = T1*(P2/P1)^(R/Cp__d_S);
Cp__d_H = R*(A+B/2*T1*(tau_d+1)+C/3*T1^2*(tau_d^2+tau_d+1)+D/(tau*T2^2));
Ws_iso = Cp__d_H*(T2_d-T1);
Ws = Ws_iso/n;
T2 = T1+(Ws/Cp_H);
tau = T2/T1;
Cp_H = R*(A+B/2*T1*(tau+1)+C/3*T1^2*(tau^2+tau+1)+D/T2^2);

end Ex7_9;
//==================================================================================