package Ex9_1
  //J M Smith, H C Van Ness and M M Abbott;Introduction to Chemical Engineering Thermodynamics; 7th Edition.
  //Chapter-9:Refrigeration and Liquefaction
  //Example: 9.1 Page 319
  //Title: Evaluate omega for carnot refrigerator and vapor compression cycle
  //==================================================================================

  model Ex9_1_a
    //==================================
    //Parameter section
    parameter Real Tr(unit = "K") = 261.15 "Temperature of refrigerator";
    parameter Real Tcw(unit = "K") = 294.15 "Temperature of cooling water available";
    parameter Real Tmin(unit = "K") = 5.6 "Minimum temperature change for heat transfer";
    parameter Real Qc(unit = "kW") = 35.2 "Refrigeration capacity";
    //==================================
    //Variable section
    Real omega_a(unit = "") "Coefficient of performance for carnot refrigerator";
    //==================================
    //Equation section
  equation
    omega_a = (Tr - Tmin) / (Tcw + Tmin - (Tr - Tmin));
  end Ex9_1_a;

  //==================================

  model Ex9_1_b
    //==================================
    //Reference section
    extends Ex9_1_a;
    //==================================
    //Parameter section
    parameter Real H2(unit = "kJ/kg") = 388.03 "Enthalpy of saturated vapor at 1.471 bar(from Table 9.1)";
    parameter Real H3dash(unit = "kJ/kg") = 420.33 "Enthalpy of saturated vapor at 6.977 bar(from Table 9.1)";
    parameter Real H1(unit = "kJ/kg")=236.83 "Enthalpy of entering stream";
    parameter Real n(unit = "")=0.8 "Efficiency of compressor";
    
    //==================================
    //Variable section
    Real omega_b(unit = "") "Coefficient of performance for carnot refrigerator";
    Real H3(unit = "kJ/kg") "Actual enthalpy after step 3";
    Real H4(unit = "kJ/kg") "Actual enthalpy after step 4";
    Real deltaHs(unit = "kJ/kg") "Enthalpy change between step 2 & 3";
    Real m(unit = "kg/s") "Circulation rate";
    
    //==================================
    //Equation section
  equation
    deltaHs = H3dash - H2;
    H3 - H2 = deltaHs / n;
    H4 = H1; //Isenthalpic process
    omega_b = (H2 - H4) / (H3 - H2);
    m = Qc / (H2 - H4);
  end Ex9_1_b;

  //==================================
end Ex9_1;
