//J M Smith, H C Van Ness and M M Abbott;Introduction to Chemical Engineering Thermodynamics; 7th Edition. 

//Chapter-9:Refrigeration and Liquefaction
//Example: 9.2 Page 326
//Title: Calculate minimum power requirements for winter heating & summer cooling
//==================================================================================
model Ex9_2

//==================================
//Parameter section
parameter Real QH_winter(unit="kJ/s")=30 "Heat requirement in winter heating";
parameter Real QC_summer(unit="kJ/s")=60 "Cooling requirement in summer cooling";
parameter Real TH_winter(unit="K")=303.15 "Highest temperature level in winter heating";
parameter Real TC_winter(unit="K")=283.15 "Lowest temperature level in winter heating";
parameter Real TH_summer(unit="K")=298.15 "Highest temperature level  in summer cooling";
parameter Real TC_summer(unit="K")=278.15 "Lowest temperature level in summer cooling";

//==================================
//Variable section
Real W_winter(unit="kJ/s") "Power required for winter heating";
Real W_summer(unit="kJ/s") "Power required for summer cooling";
Real QC_winter(unit="kJ/s") "Cooling requirement for winter heating";
//==================================
//Equation section
equation
QC_winter = QH_winter*TC_winter/TH_winter;
W_winter = QH_winter-QC_winter;
W_summer = QC_summer*(TH_summer-TC_summer)/TC_summer;

end Ex9_2;
//==================================================================================