//J M Smith, H C Van Ness and M M Abbott;Introduction to Chemical Engineering Thermodynamics; 7th Edition. 

//Chapter-1:Introduction
//Example: 1.3 Page 8
//Title: Pressure 
//==================================================================================
model Ex1_3

//==================================
//Parameter section
parameter Real h(unit = "cm") = 60.5 "Reading on manometer";
parameter Real g(unit = "m s2") = 9.784 "Local acceleration of gravity";
parameter Real r(unit = "g/cm3") = 13.53 "Density of mercury at 300.15 K";

//==================================
//Variable section
Real P(unit = "N/cm2") "Pressure";

//==================================
//Equation section
equation
P = h*r*g*0.001; //To convert g to kg

end Ex1_3;
//==================================================================================