package Ex10_1
  //J M Smith, H C Van Ness and M M Abbott;Introduction to Chemical Engineering Thermodynamics; 7th Edition.
  //Chapter-10:Vapor/Liquid Equilibrium- Introduction
  //Example: 10.1 Page 352
  //Title: Prepare P-x,y and T-x,y plots
  //==================================================================================

  model Ex10_1_a
    //==================================
    //Parameter section
    parameter Real T(unit = "K") = 348.15 "Temperature of system";
    parameter Real[6] x1(unit = "") = {0, 0.2, 0.4, 0.6, 0.8, 1} "Mole fraction of component 1 in liquid phase";
    //==================================
    //Variable section
    Real[6] y1(unit = "") "Mole fraction of component 2 in vapor phase";
    Real[6] P(unit = "kPa") "Pressure of system";
    Real P1s(unit = "kPa") "Saturation pressure of component 1";
    Real P2s(unit = "kPa") "Saturation pressure of component 1";
    Real i(unit = "") "Control variable";
    //==================================
    //Equation section
  equation
  i=1;
    log(P1s) = 14.2724 - 2945.47 / (T - 49.15);
    log(P2s) = 14.2043 - 2972.47 / (T - 64.15);
    for i in 1:6 loop
      P[i] = x1[i] * P1s + (1 - x1[i]) * P2s;
      y1[i] = x1[i] * P1s / P[i];
    end for;
  end Ex10_1_a;

  //==================================

  model Ex10_1_b
    //==================================
    //Parameter section
    parameter Real P(unit = "kPa") = 70 "Pressure of system";
     
    //==================================
    //Variable section
    Real[6] y1(unit = "") "Mole fraction of component 1  in vapor phase";
    Real[6] x1(unit = "") "Mole fraction of component 1 in liquid phase";
    Real[6] P1s(unit = "kPa") "Saturation pressure of component 1";
    Real[6] P2s(unit = "kPa") "Saturation pressure of component 2";
    Real T1s(unit = "kPa") "Saturation temperature of component 1";
    Real T2s(unit = "kPa") "Saturation temperature of component 2";
    Real[6] T(unit = "K") "Temperature of system";
    
    //==================================
    //Equation section
  equation
  log(P) = 14.2724 - 2945.47 / (T1s - 49.15);
  log(P) = 14.2043 - 2972.47 / (T2s - 64.15);
  T = {T2s,359.15,355.15,351.15,347.15,T1s}; 
    for i in 1:6 loop
      log(P1s[i]) = 14.2724 - 2945.47 / (T[i] - 49.15);
      log(P2s[i]) = 14.2043 - 2972.47 / (T[i] - 64.15);
      P = x1[i] * P1s[i] + (1 - x1[i]) * P2s[i];
      y1[i] = x1[i] * P1s[i] / P;
    end for;
  end Ex10_1_b;

  //==================================
end Ex10_1;
