//J M Smith, H C Van Ness and M M Abbott;Introduction to Chemical Engineering Thermodynamics; 7th Edition. 

//Chapter-12:Solution Thermodynamics: Applications
//Example: 12.8 Page 467
//Title: Calculate enthalpy of solid NaOH
//==================================================================================
model Ex12_8

//==================================
//Parameter section
parameter Real deltaH_infi(unit="kcal")=-10.637 "Heat of solution at infinite dilution";

//==================================
//Variable section
Real deltaH(unit="kJ/kg") "Enthalpy of solid NaOH";

//==================================
//Equation section
equation
deltaH = -deltaH_infi*4.1868*1000/40; //kcal to kJ/kg conversion

end Ex12_8;
//==================================================================================