//J M Smith, H C Van Ness and M M Abbott;Introduction to Chemical Engineering Thermodynamics; 7th Edition. 

//Chapter-13:Chemical-Reaction Equilibria
//Example: 13.10 Page 511
//Title: Calculate the the composition formed when ethylene reacts with water
//==================================================================================
model Ex13_10

//==================================
//Parameter section
parameter Real T1(unit="K")=473.15 "Temperature of reaction";
parameter Real T0(unit="K")=298.15 "Reference temperature";
parameter Real P(unit="bar")=34.5 "Pressure of reaction";
parameter Real[3] Tc(unit="K")={513.9,647.1,282.3} "Critical temperatures";
parameter Real[3] Pc(unit="bar")={61.48,220.55,50.4} "Critical pressures";
parameter Real[3] omega(unit="")={0.645,0.345,0.087} ;
parameter Real[3] P_sat(unit="bar")={30.22,15.55,0} ;

//==================================
//Variable section
Real[3] B0(unit="cm^3/mol") "Virial coefficients";
Real[3] B1(unit="cm^3/mol") "Virial coefficients";
Real[3] Tr(unit="K") "Reduced temperatures";
Real[3] phi(unit="cm^3/mol") "Fugacity coefficients";
Real[3] phi_sat(unit="cm^3/mol") "Fugacity coefficients";
Real[3] Pr(unit="kPa") "Reduced pressure";
Real[3] Pr_sat(unit="kPa") "Reduced saturated pressure";
Real[2] gamma;
Real K "Equilibrium constant";
Real[3] x "Liquid phase composition";
Real[3] y "Vapor phase composition";

//==================================
//Equation section
equation
for i in 1:3 loop
Tr[i] = T1/Tc[i];
Pr[i] = P/Pc[i];
Pr_sat[i] = P_sat[i]/Pc[i];
B0[i] = 0.083-0.422/Tr[i]^1.6;
B1[i] = 0.139-0.172/Tr[i]^4.2;
phi[i] = exp(Pr[i]/Tr[i]*(B0[i]+omega[i]*B1[i]));
phi_sat[i] = exp(Pr_sat[i]/Tr[i]*(B0[i]+omega[i]*B1[i]));
end for;
K = 0.0310; //calculated by general equation from ex 13.4
gamma[1] = 3.45047;
gamma[2] = 0.99164;   //from reference given by Otsuki & Williams
K = x[1]*gamma[1]*phi_sat[1]*P_sat[1]/(y[3]*phi[3]*P*x[2]*gamma[2]*phi_sat[2]*P_sat[2]);
y[3] = 1-x[1]*gamma[1]*phi_sat[1]*P_sat[1]/(phi[1]*P)-x[2]*gamma[2]*phi_sat[2]*P_sat[2]/(phi[2]*P);
x[3] = 0; //more volatile
x[2] = 1-x[1];
y[1] = x[1]*gamma[1]*phi_sat[1]*P_sat[1]/(phi[1]*P);
y[2] = x[2]*gamma[2]*phi_sat[2]*P_sat[2]/(phi[2]*P);
//The answer might slightly vary due to rounding off values during iteration

end Ex13_10;
//==================================================================================
